/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.sf.jml.Email;
import net.sf.jml.MsnClientId;
import net.sf.jml.MsnConnection;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.event.MsnSwitchboardAdapter;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnConnectionImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.impl.MsnOwnerImpl;
import net.sf.jml.impl.SimpleSwitchboard;
import net.sf.jml.net.Session;
import net.sf.jml.net.SessionAdapter;
import net.sf.jml.net.SessionListener;
import net.sf.jml.protocol.MsnMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.incoming.IncomingXFR;
import net.sf.jml.protocol.outgoing.OutgoingCVR;
import net.sf.jml.protocol.outgoing.OutgoingPNG;
import net.sf.jml.protocol.outgoing.OutgoingVER;
import net.sf.jml.protocol.soap.OIM;

public abstract class BasicMessenger
extends AbstractMessenger {
    private final MsnOwnerImpl owner;
    private final MsnContactListImpl contactList;
    private MsnConnectionImpl connection;
    protected MsnSession session;
    private Vector<SessionListener> preLoginSessionListeners = new Vector();
    private final Set<MsnSwitchboard> switchboards = new HashSet<MsnSwitchboard>();

    public BasicMessenger(Email email, String string) {
        this.owner = new MsnOwnerImpl(this, email, string);
        this.contactList = new MsnContactListImpl(this);
    }

    public MsnOwner getOwner() {
        return this.owner;
    }

    public MsnContactList getContactList() {
        return this.contactList;
    }

    public MsnConnection getConnection() {
        return this.connection;
    }

    public void login() {
        this.login("messenger.hotmail.com", 1863);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logout() {
        MsnSwitchboard[] msnSwitchboardArray;
        if (this.session == null) {
            return;
        }
        for (MsnSwitchboard msnSwitchboard : msnSwitchboardArray = this.getActiveSwitchboards()) {
            msnSwitchboard.close();
        }
        Set<MsnSwitchboard> set = this.switchboards;
        synchronized (set) {
            this.switchboards.clear();
        }
        this.session.close();
    }

    public boolean send(MsnOutgoingMessage msnOutgoingMessage, boolean bl) {
        if (this.session == null) {
            return false;
        }
        if (bl) {
            return this.session.sendSynchronousMessage(msnOutgoingMessage);
        }
        this.session.sendAsynchronousMessage(msnOutgoingMessage);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnSwitchboard[] getActiveSwitchboards() {
        Set<MsnSwitchboard> set = this.switchboards;
        synchronized (set) {
            MsnSwitchboard[] msnSwitchboardArray = new MsnSwitchboard[this.switchboards.size()];
            this.switchboards.toArray(msnSwitchboardArray);
            return msnSwitchboardArray;
        }
    }

    public MsnMessageChain getIncomingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getIncomingMessageChain();
    }

    public MsnMessageChain getOutgoingMessageChain() {
        if (this.session == null) {
            return null;
        }
        return this.session.getOutgoingMessageChain();
    }

    public synchronized void login(String string, int n) {
        if (this.session != null && this.session.isAvailable()) {
            return;
        }
        this.connection = new MsnConnectionImpl();
        this.connection.setRemoteIP(string);
        this.connection.setRemotePort(n);
        this.session = new MsnSession(this, (SocketAddress)new InetSocketAddress(string, n));
        this.session.addSessionListener(new MessengerSessionListener());
        for (SessionListener sessionListener : this.preLoginSessionListeners) {
            this.session.addSessionListener(sessionListener);
        }
        this.getFileTransferManager().setSession(this.session);
        this.session.start();
    }

    public void setActualMsnProtocol(MsnProtocol msnProtocol) {
        super.setActualMsnProtocol(msnProtocol);
        this.owner.fSetClientId(MsnClientId.getDefaultSupportedClientId(msnProtocol));
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (this.session != null) {
            this.session.addSessionListener(sessionListener);
        } else {
            this.preLoginSessionListeners.add(sessionListener);
        }
    }

    public void removeSessionListener(SessionListener sessionListener) {
        if (this.session != null) {
            this.session.removeSessionListener(sessionListener);
        } else {
            this.preLoginSessionListeners.remove(sessionListener);
        }
    }

    public String toString() {
        return "MsnMessenger: " + this.owner.getEmail();
    }

    public void sendText(final Email email, final String string) {
        MsnSwitchboard[] msnSwitchboardArray;
        if (email == null || string == null) {
            return;
        }
        MsnContact msnContact = this.contactList.getContactByEmail(email);
        if (msnContact != null && msnContact.getStatus().equals(MsnUserStatus.OFFLINE)) {
            new OIM(this.session).sendOfflineMsg(email, string);
            return;
        }
        for (MsnSwitchboard msnSwitchboard : msnSwitchboardArray = this.getActiveSwitchboards()) {
            if (!msnSwitchboard.containContact(email) || msnSwitchboard.getAllContacts().length != 1) continue;
            msnSwitchboard.sendText(string);
            return;
        }
        final Object object = new Object();
        this.addSwitchboardListener(new MsnSwitchboardAdapter(){

            public void switchboardStarted(MsnSwitchboard msnSwitchboard) {
                if (msnSwitchboard.getAttachment() == object) {
                    msnSwitchboard.inviteContact(email);
                }
            }

            public void contactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
                if (msnSwitchboard.getAttachment() == object && email.equals(msnContact.getEmail())) {
                    msnSwitchboard.setAttachment(null);
                    BasicMessenger.this.removeSwitchboardListener(this);
                    msnSwitchboard.sendText(string);
                }
            }
        });
        this.newSwitchboard(object);
    }

    public void retreiveOfflineMessages() {
        if (!this.session.getMessenger().getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            new OIM(this.session).retreiveOfflineMessages();
        }
    }

    public void setDeleteOfflineMessages(boolean bl) {
        new OIM(this.session).setPostDel(bl);
    }

    public MsnSwitchboard newSwitchboard(String string, int n, boolean bl, String string2, int n2, Object object) {
        final SimpleSwitchboard simpleSwitchboard = new SimpleSwitchboard(this, bl, string, n);
        simpleSwitchboard.setAuthStr(string2);
        simpleSwitchboard.addSessionListener(new SessionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionEstablished(Session session) {
                Set set = BasicMessenger.this.switchboards;
                synchronized (set) {
                    BasicMessenger.this.switchboards.add(simpleSwitchboard);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionClosed(Session session) {
                Set set = BasicMessenger.this.switchboards;
                synchronized (set) {
                    BasicMessenger.this.switchboards.remove(simpleSwitchboard);
                }
            }
        });
        simpleSwitchboard.setSessionId(n2);
        simpleSwitchboard.setAttachment(object);
        simpleSwitchboard.start();
        return simpleSwitchboard;
    }

    private class MessengerSessionListener
    extends SessionAdapter {
        private MessengerSessionListener() {
        }

        public void sessionEstablished(Session session) {
            Socket socket = session.getSocket();
            BasicMessenger.this.connection.setInternalIP(socket.getLocalAddress().getHostAddress());
            BasicMessenger.this.connection.setInternalPort(socket.getLocalPort());
            OutgoingVER outgoingVER = new OutgoingVER(null);
            outgoingVER.setSupportedProtocol(BasicMessenger.this.getSupportedProtocol());
            BasicMessenger.this.send(outgoingVER, false);
            OutgoingCVR outgoingCVR = new OutgoingCVR(null);
            outgoingCVR.setEmail(BasicMessenger.this.owner.getEmail());
            BasicMessenger.this.send(outgoingCVR, false);
        }

        public void sessionTimeout(Session session) {
            OutgoingPNG outgoingPNG = new OutgoingPNG(BasicMessenger.this.getActualMsnProtocol());
            BasicMessenger.this.send(outgoingPNG, false);
        }

        public void sessionClosed(Session session) {
            MsnMessage msnMessage;
            MsnMessageChain msnMessageChain = ((MsnSession)session.getAttachment()).getIncomingMessageChain();
            MsnMessageIterator msnMessageIterator = msnMessageChain.iterator();
            if (msnMessageIterator.hasPrevious() && (msnMessage = msnMessageIterator.previous()) instanceof IncomingXFR && !((IncomingXFR)msnMessage).isTransferredToSwitchboard()) {
                return;
            }
            BasicMessenger.this.logout();
            BasicMessenger.this.fireLogout();
            BasicMessenger.this.connection = null;
        }
    }
}

