/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheRecordStore;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CachePartitionSegment {
    private final NodeEngine nodeEngine;
    private final CacheService cacheService;
    private final int partitionId;
    private final ConstructorFunction<String, ICacheRecordStore> cacheConstructorFunction = new ConstructorFunction<String, ICacheRecordStore>(){

        @Override
        public ICacheRecordStore createNew(String name) {
            return new CacheRecordStore(name, CachePartitionSegment.this.partitionId, CachePartitionSegment.this.nodeEngine, CachePartitionSegment.this.cacheService);
        }
    };
    private final ConcurrentMap<String, ICacheRecordStore> caches = new ConcurrentHashMap<String, ICacheRecordStore>();

    CachePartitionSegment(NodeEngine nodeEngine, CacheService cacheService, int partitionId) {
        this.nodeEngine = nodeEngine;
        this.cacheService = cacheService;
        this.partitionId = partitionId;
    }

    public Iterator<ICacheRecordStore> cacheIterator() {
        return this.caches.values().iterator();
    }

    public Collection<CacheConfig> getCacheConfigs() {
        return this.cacheService.getCacheConfigs();
    }

    int getPartitionId() {
        return this.partitionId;
    }

    ICacheRecordStore getOrCreateCache(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.caches, name, this.cacheConstructorFunction);
    }

    ICacheRecordStore getCache(String name) {
        return (ICacheRecordStore)this.caches.get(name);
    }

    void deleteCache(String name) {
        ICacheRecordStore cache = (ICacheRecordStore)this.caches.remove(name);
        if (cache != null) {
            cache.destroy();
        }
    }

    void clear() {
        for (String name : this.caches.keySet()) {
            this.deleteCache(name);
        }
        this.caches.clear();
    }

    void destroy() {
        this.clear();
    }

    boolean hasCache() {
        return !this.caches.isEmpty();
    }
}

