/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapInitChunkOperation;
import com.hazelcast.replicatedmap.impl.record.AbstractBaseReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.VectorClockTimestamp;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.Clock;
import java.util.ArrayList;

final class RemoteProvisionTask<K, V>
implements Runnable {
    private final AbstractBaseReplicatedRecordStore<K, V> replicatedRecordStore;
    private final OperationService operationService;
    private final Address callerAddress;
    private final int chunkSize;
    private ReplicatedRecord[] recordCache;
    private int recordCachePos;

    RemoteProvisionTask(AbstractBaseReplicatedRecordStore<K, V> replicatedRecordStore, NodeEngine nodeEngine, Address callerAddress, int chunkSize) {
        this.replicatedRecordStore = replicatedRecordStore;
        this.operationService = nodeEngine.getOperationService();
        this.callerAddress = callerAddress;
        this.chunkSize = chunkSize;
    }

    @Override
    public void run() {
        this.recordCache = new ReplicatedRecord[this.chunkSize];
        ArrayList replicatedRecords = new ArrayList(this.replicatedRecordStore.storage.values());
        for (int i = 0; i < replicatedRecords.size(); ++i) {
            ReplicatedRecord replicatedRecord = (ReplicatedRecord)replicatedRecords.get(i);
            this.processReplicatedRecord(replicatedRecord, i == replicatedRecords.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplicatedRecord(ReplicatedRecord<K, V> replicatedRecord, boolean finalRecord) {
        Object marshalledKey = this.replicatedRecordStore.marshallKey(replicatedRecord.getKey());
        Object object = this.replicatedRecordStore.getMutex(marshalledKey);
        synchronized (object) {
            this.pushReplicatedRecord(replicatedRecord, finalRecord);
        }
    }

    private void pushReplicatedRecord(ReplicatedRecord<K, V> replicatedRecord, boolean finalRecord) {
        if (this.recordCachePos == this.chunkSize) {
            this.sendChunk(finalRecord);
        }
        int hash = replicatedRecord.getLatestUpdateHash();
        Object key = this.replicatedRecordStore.unmarshallKey(replicatedRecord.getKey());
        Object value = this.replicatedRecordStore.unmarshallValue(replicatedRecord.getValue());
        VectorClockTimestamp vectorClockTimestamp = replicatedRecord.getVectorClockTimestamp();
        long originalTtlMillis = replicatedRecord.getTtlMillis();
        long remainingTtlMillis = this.getRemainingTtl(replicatedRecord);
        if (originalTtlMillis == 0L || remainingTtlMillis > 0L) {
            this.recordCache[this.recordCachePos++] = new ReplicatedRecord<Object, Object>(key, value, vectorClockTimestamp, hash, remainingTtlMillis);
        }
        if (finalRecord) {
            this.sendChunk(finalRecord);
        }
    }

    private long getRemainingTtl(ReplicatedRecord<K, V> replicatedRecord) {
        long ttl = replicatedRecord.getTtlMillis();
        if (ttl != 0L) {
            long updateTime = replicatedRecord.getUpdateTime();
            long currentTime = Clock.currentTimeMillis();
            ttl -= currentTime - updateTime;
        }
        return ttl;
    }

    private void sendChunk(boolean finalChunk) {
        if (this.recordCachePos > 0) {
            String name = this.replicatedRecordStore.getName();
            Member localMember = this.replicatedRecordStore.localMember;
            ReplicatedMapInitChunkOperation operation = new ReplicatedMapInitChunkOperation(name, localMember, this.recordCache, this.recordCachePos, finalChunk);
            this.operationService.send(operation, this.callerAddress);
            this.recordCache = new ReplicatedRecord[this.chunkSize];
            this.recordCachePos = 0;
        }
    }
}

