/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.AbstractRecordStore;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.eviction.EvictionHelper;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    protected static final int POST_READ_CHECK_POINT = 63;
    protected volatile boolean expirable;
    protected Iterator<Record> expirationIterator;
    protected int readCountBeforeCleanUp;
    protected long lruAccessSequenceNumber;
    protected long lastEvictionTime;
    private final boolean evictionEnabled;
    private final long minEvictionCheckMillis;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        MapConfig mapConfig = mapContainer.getMapConfig();
        this.minEvictionCheckMillis = mapConfig.getMinEvictionCheckMillis();
        this.evictionEnabled = !MapConfig.EvictionPolicy.NONE.equals((Object)mapConfig.getEvictionPolicy());
        this.expirable = this.isRecordStoreExpirable();
    }

    private boolean isRecordStoreExpirable() {
        return this.mapContainer.getMapConfig().getMaxIdleSeconds() > 0 || this.mapContainer.getMapConfig().getTimeToLiveSeconds() > 0;
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean backup) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evictedEntryCount = 0;
        while ((evictedEntryCount += this.evictExpiredEntriesInternal(maxIterationCount, now, backup)) < maxIterationCount && ++loop <= 3) {
        }
    }

    @Override
    public boolean isExpirable() {
        return this.expirable;
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntriesInternal(int maxIterationCount, long now, boolean backup) {
        int evictedCount = 0;
        this.initExpirationIterator();
        for (int checkedEntryCount = 0; this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount; ++checkedEntryCount) {
            Record record = this.expirationIterator.next();
            Data key = record.getKey();
            if (this.isLocked(key) || this.isReachable(record, now)) continue;
            Object value = record.getValue();
            this.evictInternal(key, backup);
            ++evictedCount;
            if (backup) continue;
            this.doPostEvictionOperations(key, value, backup);
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.records.values().iterator();
        }
    }

    protected void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    protected void evictEntries(long now, boolean backup) {
        if (this.evictionEnabled) {
            this.cleanUp(now, backup);
        }
    }

    protected void postReadCleanUp(long now, boolean backup) {
        if (this.evictionEnabled) {
            ++this.readCountBeforeCleanUp;
            if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
                this.cleanUp(now, backup);
            }
        }
    }

    private void cleanUp(long now, boolean backup) {
        if (this.size() == 0) {
            return;
        }
        if (this.shouldEvict(now)) {
            this.removeEvictables(backup);
            this.lastEvictionTime = now;
            this.readCountBeforeCleanUp = 0;
        }
    }

    protected boolean shouldEvict(long now) {
        return this.evictionEnabled && this.inEvictableTimeWindow(now) && this.isEvictable();
    }

    private void removeEvictables(boolean backup) {
        int evictableSize = this.getEvictableSize();
        if (evictableSize < 1) {
            return;
        }
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        EvictionHelper.removeEvictableRecords(this, evictableSize, mapConfig, this.mapServiceContext, backup);
    }

    private int getEvictableSize() {
        int size = this.size();
        if (size < 1) {
            return 0;
        }
        int evictableSize = EvictionHelper.evictableSize(size, this.mapContainer.getMapConfig(), this.mapServiceContext);
        if (evictableSize < 1) {
            return 0;
        }
        return evictableSize;
    }

    private boolean inEvictableTimeWindow(long now) {
        return this.minEvictionCheckMillis == 0L || now - this.lastEvictionTime > this.minEvictionCheckMillis;
    }

    private boolean isEvictable() {
        return EvictionHelper.checkEvictable(this.mapContainer, this.partitionId);
    }

    protected void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L) {
            this.expirable = true;
        }
    }

    abstract Object evictInternal(Data var1, boolean var2);

    protected Record getOrNullIfExpired(Record record, boolean backup) {
        if (!this.expirable) {
            return record;
        }
        if (record == null) {
            return null;
        }
        Data key = record.getKey();
        if (this.isLocked(key)) {
            return record;
        }
        if (this.isReachable(record)) {
            return record;
        }
        Object value = record.getValue();
        this.evict(key, backup);
        if (!backup) {
            this.doPostEvictionOperations(key, value, backup);
        }
        return null;
    }

    private boolean isReachable(Record record) {
        long now = this.getNow();
        return this.isReachable(record, now);
    }

    private boolean isReachable(Record record, long time) {
        if (record == null) {
            return false;
        }
        Record idleExpired = this.isIdleExpired(record, time);
        if (idleExpired == null) {
            return false;
        }
        Record ttlExpired = this.isTTLExpired(record, time);
        return ttlExpired != null;
    }

    private Record isIdleExpired(Record record, long time) {
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        assert (lastAccessTime > 0L);
        assert (time > 0L);
        assert (time >= lastAccessTime);
        long idleTime = this.getIdleTime();
        boolean result = time - lastAccessTime >= idleTime;
        return result ? null : record;
    }

    private long getIdleTime() {
        int maxIdleSeconds = this.mapContainer.getMapConfig().getMaxIdleSeconds();
        return maxIdleSeconds == 0 ? Long.MAX_VALUE : this.mapServiceContext.convertTime(maxIdleSeconds, TimeUnit.SECONDS);
    }

    private Record isTTLExpired(Record record, long time) {
        if (record == null) {
            return null;
        }
        long ttl = record.getTtl();
        if (ttl < 1L) {
            return record;
        }
        long creationTime = record.getCreationTime();
        assert (ttl > 0L) : String.format("wrong ttl %d", ttl);
        assert (creationTime > 0L) : String.format("wrong creationTime %d", creationTime);
        assert (time > 0L) : String.format("wrong time %d", time);
        assert (time >= creationTime) : String.format("time >= lastUpdateTime (%d >= %d)", time, creationTime);
        boolean result = time - creationTime >= ttl;
        return result ? null : record;
    }

    private void doPostEvictionOperations(Data key, Object value, boolean backup) {
        if (backup) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(this.name)) {
            nearCacheProvider.invalidateAllNearCaches(this.name, key);
        }
        EvictionHelper.fireEvent(key, value, this.name, this.mapServiceContext);
    }

    protected void increaseRecordEvictionCriteriaNumber(Record record, MapConfig.EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case LFU: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
    }

    @Override
    protected void accessRecord(Record record, long now) {
        super.accessRecord(record, now);
        this.increaseRecordEvictionCriteriaNumber(record, this.mapContainer.getMapConfig().getEvictionPolicy());
    }

    protected final class ReadOnlyRecordIterator
    implements Iterator<Record> {
        private final Iterator<Record> iterator;
        private Record nextRecord;
        private Record lastReturned;

        protected ReadOnlyRecordIterator(Collection<Record> values) {
            this.iterator = values.iterator();
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Record next() {
            if (this.nextRecord == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextRecord;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported by this iterator");
        }

        private void advance() {
            while (this.iterator.hasNext()) {
                this.nextRecord = this.iterator.next();
                boolean reachable = AbstractEvictableRecordStore.this.isReachable(this.nextRecord);
                if (!reachable || this.nextRecord == null) continue;
                return;
            }
            this.nextRecord = null;
        }
    }
}

