/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignaturePermissions {
    boolean certification = false;
    boolean fillInAllowed = true;
    boolean annotationsAllowed = true;
    List<FieldLock> fieldLocks = new ArrayList<FieldLock>();

    public SignaturePermissions(PdfDictionary sigDict, SignaturePermissions previous) {
        PdfArray ref;
        if (previous != null) {
            this.annotationsAllowed &= previous.isAnnotationsAllowed();
            this.fillInAllowed &= previous.isFillInAllowed();
            this.fieldLocks.addAll(previous.getFieldLocks());
        }
        if ((ref = sigDict.getAsArray(PdfName.REFERENCE)) != null) {
            block4: for (int i = 0; i < ref.size(); ++i) {
                PdfNumber p;
                PdfName action;
                PdfDictionary dict = ref.getAsDict(i);
                PdfDictionary params = dict.getAsDict(PdfName.TRANSFORMPARAMS);
                if (PdfName.DOCMDP.equals(dict.getAsName(PdfName.TRANSFORMMETHOD))) {
                    this.certification = true;
                }
                if ((action = params.getAsName(PdfName.ACTION)) != null) {
                    this.fieldLocks.add(new FieldLock(action, params.getAsArray(PdfName.FIELDS)));
                }
                if ((p = params.getAsNumber(PdfName.P)) == null) continue;
                switch (p.intValue()) {
                    default: {
                        continue block4;
                    }
                    case 1: {
                        this.fillInAllowed &= false;
                    }
                    case 2: {
                        this.annotationsAllowed &= false;
                    }
                }
            }
        }
    }

    public boolean isCertification() {
        return this.certification;
    }

    public boolean isFillInAllowed() {
        return this.fillInAllowed;
    }

    public boolean isAnnotationsAllowed() {
        return this.annotationsAllowed;
    }

    public List<FieldLock> getFieldLocks() {
        return this.fieldLocks;
    }

    public class FieldLock {
        PdfName action;
        PdfArray fields;

        public FieldLock(PdfName action, PdfArray fields) {
            this.action = action;
            this.fields = fields;
        }

        public PdfName getAction() {
            return this.action;
        }

        public PdfArray getFields() {
            return this.fields;
        }

        public String toString() {
            return this.action.toString() + (this.fields == null ? "" : this.fields.toString());
        }
    }
}

