/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class SsiDataModResponse
extends SsiCommand {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_NO_SUCH_ITEM = 2;
    public static final int RESULT_CANT_ADD_ANOTHER_ROOT_GROUP = 3;
    public static final int RESULT_ID_TAKEN = 10;
    public static final int RESULT_MAX_ITEMS = 12;
    public static final int RESULT_NO_ICQ = 13;
    private final int result;

    protected SsiDataModResponse(SnacPacket snacPacket) {
        super(14);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.result = BinaryTools.getUShort(byteBlock, 0);
    }

    public SsiDataModResponse(int n) {
        super(14);
        DefensiveTools.checkRange(n, "result", 0);
        this.result = n;
    }

    public final int getResult() {
        return this.result;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.result);
    }

    public String toString() {
        return "SsiDataModAck: result=0x" + Integer.toHexString(this.result);
    }
}

