/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObj;

public abstract class ItemsCmd
extends SsiCommand {
    private final SsiItem[] items;

    protected ItemsCmd(int n, SnacPacket snacPacket) {
        super(n);
        SsiItem ssiItem;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        LinkedList<SsiItem> linkedList = new LinkedList<SsiItem>();
        while ((ssiItem = SsiItem.readSsiItem(byteBlock)) != null) {
            linkedList.add(ssiItem);
            byteBlock = byteBlock.subBlock(ssiItem.getTotalSize());
        }
        this.items = linkedList.toArray(new SsiItem[0]);
    }

    protected ItemsCmd(int n, SsiItemObj[] ssiItemObjArray) {
        this(n, AbstractItemObj.generateSsiItems(ssiItemObjArray));
    }

    protected ItemsCmd(int n, SsiItem[] ssiItemArray) {
        super(n);
        DefensiveTools.checkNull(ssiItemArray, "items");
        this.items = (SsiItem[])ssiItemArray.clone();
    }

    public final SsiItem[] getItems() {
        return (SsiItem[])this.items.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].write(outputStream);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": " + this.items.length + " items: " + Arrays.asList(this.items);
    }
}

