/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.RedirectorElement;
import org.apache.tools.ant.types.Reference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Java
extends Task {
    private CommandlineJava cmdl;
    private Environment env;
    private boolean fork;
    private boolean newEnvironment;
    private File dir;
    private boolean failOnError;
    private Long timeout;
    private String inputString;
    private File input;
    private File output;
    private File error;
    protected Redirector redirector;
    protected RedirectorElement redirectorElement;
    private String resultProperty;
    private Permissions perm;
    private boolean spawn;
    private boolean incompatibleWithSpawn;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File file = this.dir;
        Permissions permissions = this.perm;
        int n = -1;
        try {
            n = this.executeJava();
            if (n != 0) {
                if (this.failOnError) {
                    throw new BuildException("Java returned: " + n, this.getLocation());
                }
                this.log("Java Result: " + n, 0);
            }
            this.maybeSetResultPropertyValue(n);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.dir = file;
            this.perm = permissions;
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.dir = file;
            this.perm = permissions;
            return;
        }
    }

    public int executeJava() throws BuildException {
        String string = this.cmdl.getClassname();
        if (string == null && this.cmdl.getJar() == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (!this.fork && this.cmdl.getJar() != null) {
            throw new BuildException("Cannot execute a jar in non-forked mode. Please set fork='true'. ");
        }
        if (this.spawn && !this.fork) {
            throw new BuildException("Cannot spawn a java process in non-forked mode. Please set fork='true'. ");
        }
        if (this.spawn && this.incompatibleWithSpawn) {
            this.getProject().log("spawn does not allow attributes related to input, output, error, result", 0);
            this.getProject().log("spawn also does not allow timeout", 0);
            this.getProject().log("finally, spawn is not compatible with a nested I/O <redirector>", 0);
            throw new BuildException("You have used an attribute or nested element which is not compatible with spawn");
        }
        if (this.cmdl.getAssertions() != null && !this.fork) {
            this.log("Assertion statements are currently ignored in non-forked mode");
        }
        if (this.fork) {
            if (this.perm != null) {
                this.log("Permissions can not be set this way in forked mode.", 1);
            }
            this.log(this.cmdl.describeCommand(), 3);
        } else {
            if (this.cmdl.getVmCommand().size() > 1) {
                this.log("JVM args ignored when same JVM is used.", 1);
            }
            if (this.dir != null) {
                this.log("Working directory ignored when same JVM is used.", 1);
            }
            if (this.newEnvironment || this.env.getVariables() != null) {
                this.log("Changes to environment variables are ignored when same JVM is used.", 1);
            }
            if (this.cmdl.getBootclasspath() != null) {
                this.log("bootclasspath ignored when same JVM is used.", 1);
            }
            if (this.perm == null && this.failOnError) {
                this.perm = new Permissions(true);
                this.log("running " + this.cmdl.getClassname() + " with default permissions (exit forbidden)", 3);
            }
            this.log("Running in same VM " + this.cmdl.describeJavaCommand(), 3);
        }
        this.setupRedirector();
        try {
            if (this.fork) {
                if (!this.spawn) {
                    return this.fork(this.cmdl.getCommandline());
                }
                this.spawn(this.cmdl.getCommandline());
                return 0;
            }
            try {
                this.run(this.cmdl);
                return 0;
            }
            catch (ExitException exitException) {
                return exitException.getStatus();
            }
        }
        catch (BuildException buildException) {
            if (this.failOnError) {
                throw buildException;
            }
            this.log(buildException);
            return 0;
        }
        catch (Throwable throwable) {
            if (this.failOnError) {
                throw new BuildException(throwable);
            }
            this.log(throwable);
            return 0;
        }
    }

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        return this.cmdl.createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.cmdl.createBootclasspath(this.getProject()).createPath();
    }

    public Permissions createPermissions() {
        if (this.perm == null) {
            this.perm = new Permissions();
        }
        return this.perm;
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setJar(File file) throws BuildException {
        if (this.cmdl.getClassname() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command.");
        }
        this.cmdl.setJar(file.getAbsolutePath());
    }

    public void setClassname(String string) throws BuildException {
        if (this.cmdl.getJar() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command");
        }
        this.cmdl.setClassname(string);
    }

    public void setArgs(String string) {
        this.log("The args attribute is deprecated. Please use nested arg elements.", 1);
        this.cmdl.createArgument().setLine(string);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setResultProperty(String string) {
        this.resultProperty = string;
        this.incompatibleWithSpawn = true;
    }

    protected void maybeSetResultPropertyValue(int n) {
        String string = Integer.toString(n);
        if (this.resultProperty != null) {
            this.getProject().setNewProperty(this.resultProperty, string);
        }
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setJvmargs(String string) {
        this.log("The jvmargs attribute is deprecated. Please use nested jvmarg elements.", 1);
        this.cmdl.createVmArgument().setLine(string);
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setJvm(String string) {
        this.cmdl.setVm(string);
    }

    public void addSysproperty(Environment.Variable variable) {
        this.cmdl.addSysproperty(variable);
    }

    public void addSyspropertyset(PropertySet propertySet) {
        this.cmdl.addSyspropertyset(propertySet);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        this.incompatibleWithSpawn |= bl;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setOutput(File file) {
        this.output = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInput(File file) {
        if (this.inputString != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.input = file;
        this.incompatibleWithSpawn = true;
    }

    public void setInputString(String string) {
        if (this.input != null) {
            throw new BuildException("The \"input\" and \"inputstring\" attributes cannot both be specified");
        }
        this.inputString = string;
        this.incompatibleWithSpawn = true;
    }

    public void setLogError(boolean bl) {
        this.redirector.setLogError(bl);
        this.incompatibleWithSpawn |= bl;
    }

    public void setError(File file) {
        this.error = file;
        this.incompatibleWithSpawn = true;
    }

    public void setOutputproperty(String string) {
        this.redirector.setOutputProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setErrorProperty(String string) {
        this.redirector.setErrorProperty(string);
        this.incompatibleWithSpawn = true;
    }

    public void setMaxmemory(String string) {
        this.cmdl.setMaxmemory(string);
    }

    public void setJVMVersion(String string) {
        this.cmdl.setVmversion(string);
    }

    public void addEnv(Environment.Variable variable) {
        this.env.addVariable(variable);
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void setAppend(boolean bl) {
        this.redirector.setAppend(bl);
        this.incompatibleWithSpawn = true;
    }

    public void setTimeout(Long l) {
        this.timeout = l;
        boolean bl = false;
        if (this.timeout != null) {
            bl = true;
        }
        this.incompatibleWithSpawn |= bl;
    }

    public void addAssertions(Assertions assertions) {
        if (this.cmdl.getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.cmdl.setAssertions(assertions);
    }

    public void addConfiguredRedirector(RedirectorElement redirectorElement) {
        if (this.redirectorElement != null) {
            throw new BuildException("cannot have > 1 nested <redirector>s");
        }
        this.redirectorElement = redirectorElement;
        this.incompatibleWithSpawn = true;
    }

    protected void handleOutput(String string) {
        if (this.redirector.getOutputStream() != null) {
            this.redirector.handleOutput(string);
        } else {
            super.handleOutput(string);
        }
    }

    public int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.redirector.getInputStream() != null) {
            return this.redirector.handleInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    protected void handleFlush(String string) {
        if (this.redirector.getOutputStream() != null) {
            this.redirector.handleFlush(string);
        } else {
            super.handleFlush(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.redirector.getErrorStream() != null) {
            this.redirector.handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    protected void handleErrorFlush(String string) {
        if (this.redirector.getErrorStream() != null) {
            this.redirector.handleErrorFlush(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    protected void setupRedirector() {
        this.redirector.setInput(this.input);
        this.redirector.setInputString(this.inputString);
        this.redirector.setOutput(this.output);
        this.redirector.setError(this.error);
        if (this.redirectorElement != null) {
            this.redirectorElement.configure(this.redirector);
        }
    }

    private final void run(CommandlineJava commandlineJava) throws BuildException {
        try {
            ExecuteJava executeJava = new ExecuteJava();
            executeJava.setJavaCommand(commandlineJava.getJavaCommand());
            executeJava.setClasspath(commandlineJava.getClasspath());
            executeJava.setSystemProperties(commandlineJava.getSystemProperties());
            executeJava.setPermissions(this.perm);
            executeJava.setTimeout(this.timeout);
            this.redirector.createStreams();
            executeJava.execute(this.getProject());
            this.redirector.complete();
            if (executeJava.killedProcess()) {
                throw new BuildException("Timeout: killed the sub-process");
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private final int fork(String[] stringArray) throws BuildException {
        int n;
        Execute execute = new Execute(this.redirector.createHandler(), this.createWatchdog());
        execute.setAntRun(this.getProject());
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        } else if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.getLocation());
        }
        execute.setWorkingDirectory(this.dir);
        String[] stringArray2 = this.env.getVariables();
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                this.log("Setting environment variable: " + stringArray2[n], 3);
                ++n;
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(stringArray2);
        execute.setCommandline(stringArray);
        try {
            n = execute.execute();
            this.redirector.complete();
            if (execute.killedProcess()) {
                throw new BuildException("Timeout: killed the sub-process");
            }
            return n;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    private final void spawn(String[] stringArray) throws BuildException {
        Execute execute = new Execute();
        execute.setAntRun(this.getProject());
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        } else if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.getLocation());
        }
        execute.setWorkingDirectory(this.dir);
        String[] stringArray2 = this.env.getVariables();
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                this.log("Setting environment variable: " + stringArray2[n], 3);
                ++n;
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(stringArray2);
        execute.setCommandline(stringArray);
        try {
            execute.spawn();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    protected void run(String string, Vector vector) throws BuildException {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.setClassname(string);
        int n = 0;
        while (n < vector.size()) {
            commandlineJava.createArgument().setValue((String)vector.elementAt(n));
            ++n;
        }
        this.run(commandlineJava);
    }

    public void clearArgs() {
        this.cmdl.clearJavaArgs();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    private final void log(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        this.log(stringWriter.toString(), 0);
    }

    private final /* synthetic */ void this() {
        this.cmdl = new CommandlineJava();
        this.env = new Environment();
        this.fork = false;
        this.newEnvironment = false;
        this.dir = null;
        this.failOnError = false;
        this.timeout = null;
        this.redirector = new Redirector(this);
        this.perm = null;
        this.spawn = false;
        this.incompatibleWithSpawn = false;
    }

    public Java() {
        this.this();
    }
}

