/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.TypeAdapter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AntTypeDefinition {
    private String name;
    private Class clazz;
    private Class adapterClass;
    private Class adaptToClass;
    private String className;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            return;
        }
        if (this.classLoader == null) {
            this.classLoader = clazz.getClassLoader();
        }
        if (this.className == null) {
            this.className = clazz.getName();
        }
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getExposedClass(Project project) {
        if (this.adaptToClass != null) {
            Class clazz = this.getTypeClass(project);
            if (clazz == null) {
                return null;
            }
            if (this.adaptToClass.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        if (this.adapterClass != null) {
            return this.adapterClass;
        }
        return this.getTypeClass(project);
    }

    public Class getTypeClass(Project project) {
        if (this.clazz != null) {
            return this.clazz;
        }
        try {
            this.clazz = this.classLoader == null ? Class.forName(this.className) : this.classLoader.loadClass(this.className);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            project.log("Could not load a dependent class (" + noClassDefFoundError.getMessage() + ") for type " + this.name, 4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            project.log("Could not load class (" + this.className + ") for type " + this.name, 4);
        }
        return this.clazz;
    }

    public Object create(Project project) {
        return this.icreate(project);
    }

    private final Object icreate(Project project) {
        Class clazz = this.getTypeClass(project);
        if (clazz == null) {
            return null;
        }
        Object object = this.createAndSet(project, clazz);
        if (object == null || this.adapterClass == null) {
            return object;
        }
        if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
        if (typeAdapter == null) {
            return null;
        }
        typeAdapter.setProxy(object);
        return typeAdapter;
    }

    public void checkClass(Project project) {
        if (this.clazz == null) {
            this.clazz = this.getTypeClass(project);
            if (this.clazz == null) {
                throw new BuildException("Unable to create class for " + this.getName());
            }
        }
        if (this.adapterClass != null) {
            boolean bl = true;
            if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(this.clazz)) {
                bl = false;
            }
            if (bl) {
                TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
                if (typeAdapter == null) {
                    throw new BuildException("Unable to create adapter object");
                }
                typeAdapter.checkProxyClass(this.clazz);
            }
        }
    }

    private final Object createAndSet(Project project, Class clazz) {
        try {
            Constructor constructor = null;
            boolean bl = false;
            try {
                constructor = clazz.getConstructor(new Class[0]);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class[] classArray = new Class[1];
                Class clazz2 = class$org$apache$tools$ant$Project;
                if (clazz2 == null) {
                    clazz2 = class$org$apache$tools$ant$Project = AntTypeDefinition.class("[Lorg.apache.tools.ant.Project;", false);
                }
                classArray[0] = clazz2;
                constructor = clazz.getConstructor(classArray);
                bl = false;
            }
            Object var5_11 = null;
            var5_11 = bl ? constructor.newInstance(new Object[0]) : constructor.newInstance(project);
            project.setProjectReference(var5_11);
            return var5_11;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "Type " + this.name + ": A class needed by class " + clazz + " cannot be found: " + noClassDefFoundError.getMessage();
            throw new BuildException(string, noClassDefFoundError);
        }
        catch (Throwable throwable) {
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
    }

    public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        if (antTypeDefinition == null) {
            return false;
        }
        if (antTypeDefinition.getClass() != this.getClass()) {
            return false;
        }
        if (!antTypeDefinition.getTypeClass(project).equals(this.getTypeClass(project))) {
            return false;
        }
        if (!antTypeDefinition.getExposedClass(project).equals(this.getExposedClass(project))) {
            return false;
        }
        if (antTypeDefinition.adapterClass != this.adapterClass) {
            return false;
        }
        return antTypeDefinition.adaptToClass == this.adaptToClass;
    }

    public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        if (antTypeDefinition == null) {
            return false;
        }
        if (this.getClass() != antTypeDefinition.getClass()) {
            return false;
        }
        if (!this.getClassName().equals(antTypeDefinition.getClassName())) {
            return false;
        }
        if (!this.extractClassname(this.adapterClass).equals(this.extractClassname(antTypeDefinition.adapterClass))) {
            return false;
        }
        if (!this.extractClassname(this.adaptToClass).equals(this.extractClassname(antTypeDefinition.adaptToClass))) {
            return false;
        }
        ClassLoader classLoader = antTypeDefinition.getClassLoader();
        ClassLoader classLoader2 = this.getClassLoader();
        boolean bl = false;
        if (classLoader2 != null && classLoader != null && classLoader instanceof AntClassLoader && classLoader2 instanceof AntClassLoader && ((AntClassLoader)classLoader).getClasspath().equals(((AntClassLoader)classLoader2).getClasspath())) {
            bl = true;
        }
        return bl;
    }

    private final String extractClassname(Class clazz) {
        if (clazz == null) {
            return "<null>";
        }
        return clazz.getClass().getName();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

