/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.openymsg.network.FireEvent;
import org.openymsg.network.ServiceType;
import org.openymsg.network.event.SessionChatEvent;
import org.openymsg.network.event.SessionConferenceEvent;
import org.openymsg.network.event.SessionErrorEvent;
import org.openymsg.network.event.SessionEvent;
import org.openymsg.network.event.SessionExceptionEvent;
import org.openymsg.network.event.SessionFileTransferEvent;
import org.openymsg.network.event.SessionFriendEvent;
import org.openymsg.network.event.SessionGroupEvent;
import org.openymsg.network.event.SessionListener;
import org.openymsg.network.event.SessionNewMailEvent;
import org.openymsg.network.event.SessionNotifyEvent;

public class EventDispatcher
extends Thread {
    private volatile boolean quitFlag = false;
    private volatile Collection<SessionListener> listeners = new HashSet<SessionListener>();
    private volatile Queue<FireEvent> queue = new LinkedList<FireEvent>();

    public EventDispatcher() {
        super("jYMSG Event Dispatcher thread");
    }

    public boolean addSessionListener(SessionListener sessionListener) {
        return this.listeners.add(sessionListener);
    }

    public boolean removeSessionListener(SessionListener sessionListener) {
        return this.listeners.remove(sessionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Queue<FireEvent> queue = this.queue;
        synchronized (queue) {
            this.quitFlag = true;
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(SessionEvent sessionEvent, ServiceType serviceType) {
        if (sessionEvent == null) {
            throw new IllegalArgumentException("Argument 'event' cannot be null.");
        }
        if (serviceType == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        if (this.quitFlag) {
            throw new IllegalStateException("No new events can be queued, because the dispatcher is being closed.");
        }
        Queue<FireEvent> queue = this.queue;
        synchronized (queue) {
            if (!this.queue.offer(new FireEvent(sessionEvent, serviceType))) {
                throw new IllegalStateException("Unable to offer an event to the eventqueue.");
            }
            this.queue.notifyAll();
        }
    }

    private void dispatch(FireEvent fireEvent) {
        SessionEvent sessionEvent = fireEvent.getEvent();
        block28: for (SessionListener sessionListener : this.listeners) {
            switch (fireEvent.getType()) {
                case LOGOFF: {
                    sessionListener.connectionClosed(sessionEvent);
                    continue block28;
                }
                case ISAWAY: {
                    sessionListener.friendsUpdateReceived((SessionFriendEvent)sessionEvent);
                    continue block28;
                }
                case MESSAGE: {
                    sessionListener.messageReceived(sessionEvent);
                    continue block28;
                }
                case X_OFFLINE: {
                    sessionListener.offlineMessageReceived(sessionEvent);
                    continue block28;
                }
                case NEWMAIL: {
                    sessionListener.newMailReceived((SessionNewMailEvent)sessionEvent);
                    continue block28;
                }
                case CONTACTNEW: {
                    sessionListener.contactRequestReceived(sessionEvent);
                    continue block28;
                }
                case CONFDECLINE: {
                    sessionListener.conferenceInviteDeclinedReceived((SessionConferenceEvent)sessionEvent);
                    continue block28;
                }
                case CONFINVITE: {
                    sessionListener.conferenceInviteReceived((SessionConferenceEvent)sessionEvent);
                    continue block28;
                }
                case CONFLOGON: {
                    sessionListener.conferenceLogonReceived((SessionConferenceEvent)sessionEvent);
                    continue block28;
                }
                case CONFLOGOFF: {
                    sessionListener.conferenceLogoffReceived((SessionConferenceEvent)sessionEvent);
                    continue block28;
                }
                case CONFMSG: {
                    sessionListener.conferenceMessageReceived((SessionConferenceEvent)sessionEvent);
                    continue block28;
                }
                case FILETRANSFER: {
                    sessionListener.fileTransferReceived((SessionFileTransferEvent)sessionEvent);
                    continue block28;
                }
                case NOTIFY: {
                    sessionListener.notifyReceived((SessionNotifyEvent)sessionEvent);
                    continue block28;
                }
                case LIST: {
                    sessionListener.listReceived(sessionEvent);
                    continue block28;
                }
                case FRIENDADD: {
                    sessionListener.friendAddedReceived((SessionFriendEvent)sessionEvent);
                    continue block28;
                }
                case FRIENDREMOVE: {
                    sessionListener.friendRemovedReceived((SessionFriendEvent)sessionEvent);
                    continue block28;
                }
                case GOTGROUPRENAME: {
                    sessionListener.groupRenameReceived((SessionGroupEvent)sessionEvent);
                    continue block28;
                }
                case CONTACTREJECT: {
                    sessionListener.contactRejectionReceived(sessionEvent);
                    continue block28;
                }
                case CHATJOIN: {
                    sessionListener.chatJoinReceived((SessionChatEvent)sessionEvent);
                    continue block28;
                }
                case CHATEXIT: {
                    sessionListener.chatExitReceived((SessionChatEvent)sessionEvent);
                    continue block28;
                }
                case CHATDISCONNECT: {
                    sessionListener.chatConnectionClosed(sessionEvent);
                    continue block28;
                }
                case CHATMSG: {
                    sessionListener.chatMessageReceived((SessionChatEvent)sessionEvent);
                    continue block28;
                }
                case X_CHATUPDATE: {
                    sessionListener.chatUserUpdateReceived((SessionChatEvent)sessionEvent);
                    continue block28;
                }
                case X_ERROR: {
                    sessionListener.errorPacketReceived((SessionErrorEvent)sessionEvent);
                    continue block28;
                }
                case X_EXCEPTION: {
                    sessionListener.inputExceptionThrown((SessionExceptionEvent)sessionEvent);
                    continue block28;
                }
                case X_BUZZ: {
                    sessionListener.buzzReceived(sessionEvent);
                    continue block28;
                }
            }
            throw new IllegalArgumentException("Don't know how to handle service type '" + (Object)((Object)fireEvent.getType()) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Queue<FireEvent> queue = this.queue;
        synchronized (queue) {
            while (!this.quitFlag) {
                try {
                    FireEvent fireEvent;
                    this.queue.wait();
                    while ((fireEvent = this.queue.poll()) != null) {
                        try {
                            this.dispatch(fireEvent);
                        }
                        catch (Exception exception) {
                            try {
                                this.dispatch(new FireEvent(new SessionExceptionEvent(this, "Source: EventDispatcher", exception), ServiceType.X_EXCEPTION));
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

