/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

public class SHA1 {
    private int[] m_h = new int[5];
    private int[] m_w = new int[80];
    private int m_iLenW;
    private long m_lBitCount;
    private static final byte[] s_pad0x80 = new byte[]{-128};
    private static final byte[] s_pad0x00 = new byte[]{0};

    public SHA1() {
        this.initH();
        this.initW();
    }

    public void reset() {
        this.m_lBitCount = 0L;
        this.m_iLenW = 0;
        this.initH();
        this.initW();
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = this.m_iLenW / 4;
            this.m_w[n3] = this.m_w[n3] << 8;
            int n4 = this.m_iLenW / 4;
            this.m_w[n4] = this.m_w[n4] | byArray[i] & 0xFF;
            if (++this.m_iLenW % 64 == 0) {
                this.hashBlock();
                this.m_iLenW = 0;
            }
            this.m_lBitCount += 8L;
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[]{(byte)(this.m_lBitCount >> 56 & 0xFFL), (byte)(this.m_lBitCount >> 48 & 0xFFL), (byte)(this.m_lBitCount >> 40 & 0xFFL), (byte)(this.m_lBitCount >> 32 & 0xFFL), (byte)(this.m_lBitCount >> 24 & 0xFFL), (byte)(this.m_lBitCount >> 16 & 0xFFL), (byte)(this.m_lBitCount >> 8 & 0xFFL), (byte)(this.m_lBitCount >> 0 & 0xFFL)};
        this.update(s_pad0x80, 0, 1);
        while (this.m_iLenW != 56) {
            this.update(s_pad0x00, 0, 1);
        }
        this.update(byArray, 0, 8);
        byte[] byArray2 = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray2[i] = (byte)(this.m_h[i / 4] >> 24);
            int n = i / 4;
            this.m_h[n] = this.m_h[n] << 8;
        }
        this.reset();
        return byArray2;
    }

    public void setBitCount(long l) {
        this.m_lBitCount = l;
    }

    private void initH() {
        this.m_h[0] = 1732584193;
        this.m_h[1] = -271733879;
        this.m_h[2] = -1732584194;
        this.m_h[3] = 271733878;
        this.m_h[4] = -1009589776;
    }

    private void initW() {
        for (int i = 0; i < this.m_w.length; ++i) {
            this.m_w[i] = 0;
        }
    }

    private int shaRotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private void hashBlock() {
        int n;
        int n2;
        for (n2 = 16; n2 <= 79; ++n2) {
            this.m_w[n2] = this.shaRotl(this.m_w[n2 - 3] ^ this.m_w[n2 - 8] ^ this.m_w[n2 - 14] ^ this.m_w[n2 - 16], 1);
        }
        int n3 = this.m_h[0];
        int n4 = this.m_h[1];
        int n5 = this.m_h[2];
        int n6 = this.m_h[3];
        int n7 = this.m_h[4];
        for (n2 = 0; n2 <= 19; ++n2) {
            n = this.shaRotl(n3, 5) + ((n5 ^ n6) & n4 ^ n6) + n7 + this.m_w[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = this.shaRotl(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 <= 39; ++n2) {
            n = this.shaRotl(n3, 5) + (n4 ^ n5 ^ n6) + n7 + this.m_w[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = this.shaRotl(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 <= 59; ++n2) {
            n = this.shaRotl(n3, 5) + (n4 & n5 | n6 & (n4 | n5)) + n7 + this.m_w[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = this.shaRotl(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 <= 79; ++n2) {
            n = this.shaRotl(n3, 5) + (n4 ^ n5 ^ n6) + n7 + this.m_w[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = this.shaRotl(n4, 30);
            n4 = n3;
            n3 = n;
        }
        this.m_h[0] = this.m_h[0] + n3;
        this.m_h[1] = this.m_h[1] + n4;
        this.m_h[2] = this.m_h[2] + n5;
        this.m_h[3] = this.m_h[3] + n6;
        this.m_h[4] = this.m_h[4] + n7;
    }
}

