/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.util.Arrays;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContextImplBase;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public final class TypeConstraintMappingContextImpl<C>
extends ConstraintMappingContextImplBase
implements TypeConstraintMappingContext<C> {
    public TypeConstraintMappingContextImpl(Class<?> beanClass, ConstraintMappingContext mapping) {
        super(beanClass, mapping);
        mapping.getAnnotationProcessingOptions().ignoreAnnotationConstraintForClass(beanClass, Boolean.FALSE);
    }

    @Override
    public TypeConstraintMappingContext<C> constraint(ConstraintDef<?, ?> definition) {
        this.mapping.addConstraintConfig(ConfiguredConstraint.forType(definition, this.beanClass));
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> ignoreAnnotations() {
        this.mapping.getAnnotationProcessingOptions().ignoreClassLevelConstraintAnnotations(this.beanClass, Boolean.TRUE);
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> ignoreAllAnnotations() {
        this.mapping.getAnnotationProcessingOptions().ignoreAnnotationConstraintForClass(this.beanClass, Boolean.TRUE);
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> defaultGroupSequence(Class<?> ... defaultGroupSequence) {
        this.mapping.addDefaultGroupSequence(this.beanClass, Arrays.asList(defaultGroupSequence));
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> defaultGroupSequenceProviderClass(Class<? extends DefaultGroupSequenceProvider<? super C>> defaultGroupSequenceProviderClass) {
        Class clazz = this.beanClass;
        this.mapping.addDefaultGroupSequenceProvider(clazz, defaultGroupSequenceProviderClass);
        return this;
    }
}

