/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.GenericFilterBean;

public class SchemeFilter
extends GenericFilterBean {
    private boolean enabled = true;
    private String desiredScheme = "https";
    private int desiredPort = 443;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String scheme = request.getScheme();
        if (this.enabled && !this.desiredScheme.equals(scheme)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.desiredScheme).append("://");
            buffer.append(request.getServerName());
            buffer.append(":").append(this.desiredPort);
            buffer.append(request.getRequestURI());
            response.setHeader("Location", buffer.toString());
            response.setStatus(301);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void setDesiredScheme(String desiredScheme) {
        this.desiredScheme = desiredScheme;
    }

    public void setOverridePort(int desiredPort) {
        this.desiredPort = desiredPort;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

