/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.sdp;

import gov.nist.javax.sdp.fields.AttributeField;
import javax.sdp.SdpException;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateAttribute
extends AttributeField {
    public static final String NAME = "candidate";
    private static final long serialVersionUID = 1L;
    private final Candidate<?> candidate;

    public CandidateAttribute(Candidate<?> candidate) {
        this.candidate = candidate;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
    }

    public boolean hasValue() {
        return true;
    }

    public String getValue() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.candidate.getFoundation());
        buff.append(" ").append(this.candidate.getParentComponent().getComponentID());
        buff.append(" ").append((Object)this.candidate.getTransport());
        buff.append(" ").append(this.candidate.getPriority());
        buff.append(" ").append(this.candidate.getTransportAddress().getHostAddress());
        buff.append(" ").append(this.candidate.getTransportAddress().getPort());
        buff.append(" typ ").append((Object)this.candidate.getType());
        TransportAddress relAddr = this.candidate.getRelatedAddress();
        if (relAddr != null) {
            buff.append(" raddr ").append(relAddr.getHostAddress());
            buff.append(" rport ").append(relAddr.getPort());
        }
        return buff.toString();
    }

    public void setValue(String value) throws SdpException {
    }

    public char getTypeChar() {
        return 'a';
    }

    public CandidateAttribute clone() {
        return null;
    }

    public String encode() {
        StringBuffer sbuff = new StringBuffer("a=");
        sbuff.append(this.getName()).append(":");
        sbuff.append(this.getValue());
        return sbuff.append("\r\n").toString();
    }
}

