/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.utility.LoggerSingleton;

public class InputStreamPushSourceStream
implements PushSourceStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final ContentDescriptor outputContentDescriptor;
    private final InputStream is;
    private boolean eos;
    private SourceTransferHandler transferHandler;

    public InputStreamPushSourceStream(ContentDescriptor contentDescriptor, InputStream inputStream) {
        this.outputContentDescriptor = contentDescriptor;
        this.is = inputStream;
    }

    public boolean endOfStream() {
        logger.finer(this.getClass().getSimpleName() + " endOfStream");
        return this.eos;
    }

    public ContentDescriptor getContentDescriptor() {
        logger.finer(this.getClass().getSimpleName() + " getContentDescriptor");
        return this.outputContentDescriptor;
    }

    public long getContentLength() {
        logger.finer(this.getClass().getSimpleName() + " getContentLength");
        return 0L;
    }

    public Object getControl(String string) {
        logger.finer(this.getClass().getSimpleName() + " getControl");
        return null;
    }

    public Object[] getControls() {
        logger.finer(this.getClass().getSimpleName() + " getControls");
        return new Object[0];
    }

    public int getMinimumTransferSize() {
        logger.finer(this.getClass().getSimpleName() + " getMinimumTransferSize");
        return 0;
    }

    public SourceTransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void notifyDataAvailable() {
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 < 0) {
            this.eos = true;
        }
        return n3;
    }

    public void setTransferHandler(SourceTransferHandler sourceTransferHandler) {
        logger.finer(this.getClass().getSimpleName() + " setTransferHandler");
        this.transferHandler = sourceTransferHandler;
    }
}

