/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.RrdException;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.ValueAxisUnit;
import org.jrobin.graph.ValueMarker;

class ValueGrid {
    private boolean rigid;
    private double lower;
    private double upper;
    private double baseValue = 1000.0;
    private double[] scaleValues = new double[]{1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15};
    private ValueAxisUnit vAxis;

    ValueGrid(GridRange gr, double low, double up, ValueAxisUnit vAxis, double base) throws RrdException {
        double grLower = Double.MAX_VALUE;
        double grUpper = Double.MIN_VALUE;
        if (gr != null) {
            this.rigid = gr.isRigid();
            grLower = gr.getLowerValue();
            grUpper = gr.getUpperValue();
        }
        this.lower = low;
        this.upper = up;
        this.vAxis = vAxis;
        if (base != this.baseValue) {
            int i;
            this.baseValue = base;
            double tmp = 1.0;
            for (i = 1; i < 7; ++i) {
                this.scaleValues[6 - i] = tmp *= this.baseValue;
            }
            tmp = 1.0;
            for (i = 7; i < this.scaleValues.length; ++i) {
                this.scaleValues[i] = 1.0 / (tmp *= this.baseValue);
            }
        }
        this.setValueAxis();
        if (!this.rigid) {
            this.lower = this.lower == grLower ? grLower : this.vAxis.getNiceLower(this.lower);
            this.upper = this.upper == grUpper ? grUpper : this.vAxis.getNiceHigher(this.upper);
        }
    }

    double getLowerValue() {
        return this.lower;
    }

    double getUpperValue() {
        return this.upper;
    }

    ValueMarker[] getValueMarkers() {
        return this.vAxis.getValueMarkers(this.lower, this.upper);
    }

    private void setValueAxis() throws RrdException {
        int scaleIndex;
        double shifted;
        if (this.vAxis != null) {
            return;
        }
        if (Double.isNaN(this.upper) || this.upper == Double.MIN_VALUE || this.upper == Double.MAX_VALUE) {
            this.upper = 0.9;
        }
        if (Double.isNaN(this.lower) || this.lower == Double.MAX_VALUE || this.lower == Double.MIN_VALUE) {
            this.lower = 0.0;
        }
        if (!this.rigid && this.upper == 0.0 && this.upper == this.lower) {
            this.upper = 0.9;
        }
        if ((shifted = Math.abs(this.upper - this.lower)) == 0.0) {
            shifted = this.upper;
        }
        double mod = 1.0;
        for (scaleIndex = this.scaleValues.length - 1; scaleIndex >= 0 && this.scaleValues[scaleIndex] < shifted; --scaleIndex) {
        }
        if (this.scaleValues[++scaleIndex] != 0.0) {
            shifted /= this.scaleValues[scaleIndex];
        }
        if (Double.isInfinite(shifted)) {
            throw new RrdException("ValueGrid failure: u=" + this.upper + " l=" + this.lower + " sv=" + this.scaleValues[scaleIndex]);
        }
        while (shifted > 10.0) {
            shifted /= 10.0;
            mod *= 10.0;
        }
        while (shifted < 1.0) {
            shifted *= 10.0;
            mod /= 10.0;
        }
        this.vAxis = shifted <= 2.0 ? new ValueAxisUnit(0.1 * mod * this.scaleValues[scaleIndex], 0.5 * mod * this.scaleValues[scaleIndex]) : (shifted <= 4.0 ? new ValueAxisUnit(0.2 * mod * this.scaleValues[scaleIndex], 1.0 * mod * this.scaleValues[scaleIndex]) : (shifted <= 6.0 ? new ValueAxisUnit(0.5 * mod * this.scaleValues[scaleIndex], 1.0 * mod * this.scaleValues[scaleIndex]) : new ValueAxisUnit(1.0 * mod * this.scaleValues[scaleIndex], 2.0 * mod * this.scaleValues[scaleIndex])));
    }
}

