/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Source;

class Sdef
extends Cdef {
    private int defIndex = -1;
    private String defName = "";
    private String consolFunc = "AVERAGE";
    private int aggregate = 2;
    private boolean calculated = false;
    private double[] value = null;

    Sdef(String name, String defName, String consolFunc) throws RrdException {
        super(name);
        this.defName = defName;
        this.consolFunc = consolFunc;
        if (consolFunc.equalsIgnoreCase("AVERAGE") || consolFunc.equalsIgnoreCase("AVG")) {
            this.aggregate = 2;
        } else if (consolFunc.equalsIgnoreCase("MAX") || consolFunc.equalsIgnoreCase("MAXIMUM")) {
            this.aggregate = 1;
        } else if (consolFunc.equalsIgnoreCase("MIN") || consolFunc.equalsIgnoreCase("MINIMUM")) {
            this.aggregate = 0;
        } else if (consolFunc.equalsIgnoreCase("LAST")) {
            this.aggregate = 4;
        } else if (consolFunc.equalsIgnoreCase("FIRST")) {
            this.aggregate = 3;
        } else if (consolFunc.equalsIgnoreCase("TOTAL")) {
            this.aggregate = 5;
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
    }

    void prepare(HashMap sourceIndex, int numPoints, int aggregatePoints) throws RrdException {
        if (!sourceIndex.containsKey(this.defName)) {
            throw new RrdException("Datasource not found: " + this.defName);
        }
        this.defIndex = (Integer)sourceIndex.get(this.defName);
        this.values = new double[numPoints];
        this.aggregatePoints = aggregatePoints;
        this.calculated = false;
    }

    int calculateLevel(int[] levels) {
        return levels[this.defIndex] + 1;
    }

    double get(int pos) {
        return this.values[0];
    }

    void set(Source[] sources) {
        if (this.calculated) {
            return;
        }
        double value = sources[this.defIndex].getAggregate(this.aggregate);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = value;
        }
        this.calculated = true;
    }

    double getAggregate(int aggType) {
        switch (aggType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.values[0];
            }
            case 5: {
                return this.values[0] * (double)this.values.length;
            }
        }
        return Double.NaN;
    }

    void exportXml(XmlWriter xml) {
        xml.startTag("def");
        xml.writeTag("name", this.getName());
        xml.writeTag("datasource", this.defName);
        xml.writeTag("cf", this.consolFunc);
        xml.closeTag();
    }
}

