/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;

class Comment {
    protected static final int CMT_DEFAULT = 0;
    protected static final int CMT_LEGEND = 1;
    protected static final int CMT_GPRINT = 2;
    protected static final int CMT_NOLEGEND = 3;
    protected static final Byte TKN_ALF = new Byte(1);
    protected static final Byte TKN_ARF = new Byte(2);
    protected static final Byte TKN_ACF = new Byte(3);
    protected static final Byte TKN_AL = new Byte(4);
    protected static final Byte TKN_AR = new Byte(5);
    protected static final Byte TKN_AC = new Byte(6);
    protected static final Byte TKN_NULL = null;
    protected int lineCount = 0;
    protected boolean endLf = false;
    protected boolean addSpacer = true;
    protected boolean trimString = false;
    protected int commentType = 0;
    protected Byte lfToken = TKN_ALF;
    protected String text;
    protected ArrayList oList = new ArrayList(3);

    Comment() {
    }

    Comment(String text) throws RrdException {
        this.text = text;
        if (text != null) {
            this.parseComment();
        }
    }

    void parseComment() throws RrdException {
        String text = this.text;
        int mpos = text.indexOf("@g");
        if (mpos >= 0 && mpos == text.length() - 2) {
            this.addSpacer = false;
            this.trimString = true;
            text = text.substring(0, text.length() - 2);
        } else {
            mpos = text.indexOf("@G");
            if (mpos >= 0 && mpos == text.length() - 2) {
                this.addSpacer = false;
                this.trimString = false;
                text = text.substring(0, text.length() - 2);
            }
        }
        int lastPos = 0;
        mpos = text.indexOf("@");
        int lfpos = text.indexOf("\n");
        if (mpos == text.length()) {
            mpos = -1;
        }
        if (lfpos == text.length()) {
            lfpos = -1;
        }
        while (mpos >= 0 || lfpos >= 0) {
            Byte tkn;
            if (mpos >= 0 && lfpos >= 0) {
                if (mpos < lfpos) {
                    tkn = this.getToken(text.charAt(mpos + 1));
                    if (tkn != TKN_NULL) {
                        this.oList.add(text.substring(lastPos, mpos));
                        this.oList.add(tkn);
                        lastPos = mpos + 2;
                        mpos = text.indexOf("@", lastPos);
                    } else {
                        mpos = text.indexOf("@", mpos + 1);
                    }
                } else {
                    this.oList.add(text.substring(lastPos, lfpos));
                    this.oList.add(this.lfToken);
                    this.endLf = true;
                    ++this.lineCount;
                    lastPos = lfpos + 1;
                    lfpos = text.indexOf("\n", lastPos);
                }
            } else if (mpos >= 0) {
                tkn = this.getToken(text.charAt(mpos + 1));
                if (tkn != TKN_NULL) {
                    this.oList.add(text.substring(lastPos, mpos));
                    this.oList.add(tkn);
                    lastPos = mpos + 2;
                    mpos = text.indexOf("@", lastPos);
                } else {
                    mpos = text.indexOf("@", mpos + 1);
                }
            } else {
                this.oList.add(text.substring(lastPos, lfpos));
                this.oList.add(this.lfToken);
                this.endLf = true;
                ++this.lineCount;
                lastPos = lfpos + 1;
                lfpos = text.indexOf("\n", lastPos);
            }
            if (mpos == text.length()) {
                mpos = -1;
            }
            if (lfpos != text.length()) continue;
            lfpos = -1;
        }
        if (lastPos < text.length()) {
            this.oList.add(text.substring(lastPos));
            this.oList.add(TKN_NULL);
        }
    }

    Byte getToken(char tokenChar) {
        switch (tokenChar) {
            case 'l': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ALF;
            }
            case 'L': {
                return TKN_AL;
            }
            case 'r': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ARF;
            }
            case 'R': {
                return TKN_AR;
            }
            case 'c': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ACF;
            }
            case 'C': {
                return TKN_AC;
            }
        }
        return TKN_NULL;
    }

    boolean isCompleteLine() {
        return this.endLf;
    }

    ArrayList getTokens() {
        return this.oList;
    }

    int getLineCount() {
        return this.lineCount;
    }

    boolean addSpacer() {
        return this.addSpacer;
    }

    boolean trimString() {
        return this.trimString;
    }

    String getText() {
        return this.text;
    }

    void exportXmlTemplate(XmlWriter xml) {
        xml.writeTag("comment", this.getText());
    }
}

