/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Source;

class Cdef
extends Source {
    private String[] strTokens;
    private double[] constants;
    private int[] dsIndices;
    private byte[] tokens;

    Cdef(String name) {
        super(name);
        this.strTokens = new String[0];
    }

    Cdef(String name, String rpn) {
        super(name);
        StringTokenizer st = new StringTokenizer(rpn, ",");
        int count = st.countTokens();
        this.strTokens = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.strTokens[i] = st.nextToken().trim();
            ++i;
        }
    }

    void prepare(HashMap sourceIndex, int numPoints, int aggregatePoints) throws RrdException {
        this.values = new double[numPoints];
        this.aggregatePoints = aggregatePoints;
        this.constants = new double[this.strTokens.length];
        this.dsIndices = new int[this.strTokens.length];
        this.tokens = new byte[this.strTokens.length];
        for (int i = 0; i < this.strTokens.length; ++i) {
            String tkn = this.strTokens[i];
            if (this.isNumber(tkn)) {
                this.tokens[i] = 0;
                this.constants[i] = Double.parseDouble(tkn);
                continue;
            }
            if (sourceIndex.containsKey(tkn)) {
                this.tokens[i] = 1;
                this.dsIndices[i] = (Integer)sourceIndex.get(tkn);
                continue;
            }
            if (tkn.equals("+")) {
                this.tokens[i] = 2;
                continue;
            }
            if (tkn.equals("-")) {
                this.tokens[i] = 3;
                continue;
            }
            if (tkn.equals("*")) {
                this.tokens[i] = 4;
                continue;
            }
            if (tkn.equals("/")) {
                this.tokens[i] = 5;
                continue;
            }
            if (tkn.equals("%")) {
                this.tokens[i] = 6;
                continue;
            }
            if (tkn.equals("SIN")) {
                this.tokens[i] = 7;
                continue;
            }
            if (tkn.equals("COS")) {
                this.tokens[i] = 8;
                continue;
            }
            if (tkn.equals("LOG")) {
                this.tokens[i] = 9;
                continue;
            }
            if (tkn.equals("EXP")) {
                this.tokens[i] = 10;
                continue;
            }
            if (tkn.equals("FLOOR")) {
                this.tokens[i] = 11;
                continue;
            }
            if (tkn.equals("CEIL")) {
                this.tokens[i] = 12;
                continue;
            }
            if (tkn.equals("ROUND")) {
                this.tokens[i] = 13;
                continue;
            }
            if (tkn.equals("POW")) {
                this.tokens[i] = 14;
                continue;
            }
            if (tkn.equals("ABS")) {
                this.tokens[i] = 15;
                continue;
            }
            if (tkn.equals("SQRT")) {
                this.tokens[i] = 16;
                continue;
            }
            if (tkn.equals("RANDOM")) {
                this.tokens[i] = 17;
                continue;
            }
            if (tkn.equals("LT")) {
                this.tokens[i] = 18;
                continue;
            }
            if (tkn.equals("LE")) {
                this.tokens[i] = 19;
                continue;
            }
            if (tkn.equals("GT")) {
                this.tokens[i] = 20;
                continue;
            }
            if (tkn.equals("GE")) {
                this.tokens[i] = 21;
                continue;
            }
            if (tkn.equals("EQ")) {
                this.tokens[i] = 22;
                continue;
            }
            if (tkn.equals("IF")) {
                this.tokens[i] = 23;
                continue;
            }
            if (tkn.equals("MIN")) {
                this.tokens[i] = 24;
                continue;
            }
            if (tkn.equals("MAX")) {
                this.tokens[i] = 25;
                continue;
            }
            if (tkn.equals("LIMIT")) {
                this.tokens[i] = 26;
                continue;
            }
            if (tkn.equals("DUP")) {
                this.tokens[i] = 27;
                continue;
            }
            if (tkn.equals("EXC")) {
                this.tokens[i] = 28;
                continue;
            }
            if (tkn.equals("POP")) {
                this.tokens[i] = 29;
                continue;
            }
            if (tkn.equals("UN")) {
                this.tokens[i] = 30;
                continue;
            }
            if (tkn.equals("UNKN")) {
                this.tokens[i] = 31;
                continue;
            }
            if (tkn.equals("NOW")) {
                this.tokens[i] = 32;
                continue;
            }
            if (tkn.equals("TIME")) {
                this.tokens[i] = 33;
                continue;
            }
            if (tkn.equals("PI")) {
                this.tokens[i] = 34;
                continue;
            }
            if (tkn.equals("E")) {
                this.tokens[i] = 35;
                continue;
            }
            if (tkn.equals("AND")) {
                this.tokens[i] = 36;
                continue;
            }
            if (tkn.equals("OR")) {
                this.tokens[i] = 37;
                continue;
            }
            if (tkn.equals("XOR")) {
                this.tokens[i] = 38;
                continue;
            }
            if (tkn.equals("SAMPLES")) {
                this.tokens[i] = 39;
                continue;
            }
            if (tkn.equals("STEP")) {
                this.tokens[i] = 40;
                continue;
            }
            throw new RrdException("Unknown token encountered: " + tkn);
        }
    }

    int calculateLevel(int[] levels) {
        int level = 0;
        for (int i = 0; i < this.dsIndices.length; ++i) {
            if (levels[this.dsIndices[i]] <= level) continue;
            level = levels[this.dsIndices[i]];
        }
        return level;
    }

    void set(int pos, long timestamp, double val) {
        super.set(pos, timestamp, val);
        this.values[pos] = val;
    }

    byte[] getTokens() {
        return this.tokens;
    }

    double[] getConstants() {
        return this.constants;
    }

    int[] getDsIndices() {
        return this.dsIndices;
    }

    String getRpnString() {
        StringBuffer tmpStr = new StringBuffer("");
        for (int i = 0; i < this.strTokens.length - 1; ++i) {
            tmpStr.append(this.strTokens[i]);
            tmpStr.append(',');
        }
        if (this.strTokens.length > 0) {
            tmpStr.append(this.strTokens[this.strTokens.length - 1]);
        }
        return tmpStr.toString();
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    void exportXml(XmlWriter xml) {
        xml.startTag("def");
        xml.writeTag("name", this.getName());
        xml.writeTag("rpn", this.getRpnString());
        xml.closeTag();
    }
}

