/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.jrobin.core.jrrd.Archive;
import org.jrobin.core.jrrd.ConsolidationFunctionType;
import org.jrobin.core.jrrd.DataChunk;
import org.jrobin.core.jrrd.DataSource;
import org.jrobin.core.jrrd.Header;
import org.jrobin.core.jrrd.RRDException;
import org.jrobin.core.jrrd.RRDFile;

public class RRDatabase {
    RRDFile rrdFile;
    private String name;
    Header header;
    ArrayList dataSources;
    ArrayList archives;
    Date lastUpdate;

    public RRDatabase(String name) throws IOException {
        this(new File(name));
    }

    public RRDatabase(File file) throws IOException {
        Archive archive;
        DataSource ds;
        int i;
        this.name = file.getName();
        this.rrdFile = new RRDFile(file);
        this.header = new Header(this.rrdFile);
        this.dataSources = new ArrayList();
        for (i = 0; i < this.header.dsCount; ++i) {
            ds = new DataSource(this.rrdFile);
            this.dataSources.add(ds);
        }
        this.archives = new ArrayList();
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = new Archive(this);
            this.archives.add(archive);
        }
        this.rrdFile.align();
        this.lastUpdate = new Date((long)this.rrdFile.readInt() * 1000L);
        for (i = 0; i < this.header.dsCount; ++i) {
            ds = (DataSource)this.dataSources.get(i);
            ds.loadPDPStatusBlock(this.rrdFile);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = (Archive)this.archives.get(i);
            archive.loadCDPStatusBlocks(this.rrdFile, this.header.dsCount);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = (Archive)this.archives.get(i);
            archive.loadCurrentRow(this.rrdFile);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = (Archive)this.archives.get(i);
            archive.loadData(this.rrdFile, this.header.dsCount);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public DataSource getDataSource(int index) {
        return (DataSource)this.dataSources.get(index);
    }

    public Iterator getDataSources() {
        return this.dataSources.iterator();
    }

    public Archive getArchive(int index) {
        return (Archive)this.archives.get(index);
    }

    public Iterator getArchives() {
        return this.archives.iterator();
    }

    public int getNumArchives() {
        return this.header.rraCount;
    }

    public Iterator getArchives(ConsolidationFunctionType type) {
        return this.getArchiveList(type).iterator();
    }

    ArrayList getArchiveList(ConsolidationFunctionType type) {
        ArrayList<Archive> subset = new ArrayList<Archive>();
        for (int i = 0; i < this.archives.size(); ++i) {
            Archive archive = (Archive)this.archives.get(i);
            if (!archive.getType().equals(type)) continue;
            subset.add(archive);
        }
        return subset;
    }

    public void close() throws IOException {
        this.rrdFile.close();
    }

    public void printInfo(PrintStream s) {
        DecimalFormat numberFormat = new DecimalFormat("0.0000000000E0");
        this.printInfo(s, numberFormat);
    }

    public DataChunk getData(ConsolidationFunctionType type) throws RRDException, IOException {
        return this.getData(type, 1L);
    }

    public DataChunk getData(ConsolidationFunctionType type, long step) throws RRDException, IOException {
        ArrayList possibleArchives = this.getArchiveList(type);
        if (possibleArchives.size() == 0) {
            throw new RRDException("Database does not contain an Archive of consolidation function type " + type);
        }
        Calendar endCal = Calendar.getInstance();
        endCal.set(14, 0);
        Calendar startCal = (Calendar)endCal.clone();
        startCal.add(5, -1);
        long end = endCal.getTime().getTime() / 1000L;
        long start = startCal.getTime().getTime() / 1000L;
        Archive archive = this.findBestArchive(start, end, step, possibleArchives);
        step = this.header.pdpStep * archive.pdpCount;
        start -= start % step;
        if (end % step != 0L) {
            end += step - end % step;
        }
        int rows = (int)((end - start) / step + 1L);
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        long archiveEndTime = lastUpdateLong - lastUpdateLong % step;
        long archiveStartTime = archiveEndTime - step * (long)(archive.rowCount - 1);
        int startOffset = (int)((start - archiveStartTime) / step);
        int endOffset = (int)((archiveEndTime - end) / step);
        DataChunk chunk = new DataChunk(start, startOffset, endOffset, step, this.header.dsCount, rows);
        archive.loadData(chunk);
        return chunk;
    }

    private Archive findBestArchive(long start, long end, long step, ArrayList archives) {
        Archive archive = null;
        Archive bestFullArchive = null;
        Archive bestPartialArchive = null;
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        boolean firstPart = true;
        boolean firstFull = true;
        long bestMatch = 0L;
        long bestStepDiff = 0L;
        long tmpStepDiff = 0L;
        for (int i = 0; i < archives.size(); ++i) {
            archive = (Archive)archives.get(i);
            long calEnd = lastUpdateLong - lastUpdateLong % (long)(archive.pdpCount * this.header.pdpStep);
            long calStart = calEnd - (long)(archive.pdpCount * archive.rowCount * this.header.pdpStep);
            long fullMatch = end - start;
            if (calEnd >= end && calStart < start) {
                tmpStepDiff = Math.abs(step - (long)(this.header.pdpStep * archive.pdpCount));
                if (!firstFull && tmpStepDiff >= bestStepDiff) continue;
                firstFull = false;
                bestStepDiff = tmpStepDiff;
                bestFullArchive = archive;
                continue;
            }
            long tmpMatch = fullMatch;
            if (calStart > start) {
                tmpMatch -= calStart - start;
            }
            if (calEnd < end) {
                tmpMatch -= end - calEnd;
            }
            if (!firstPart && bestMatch >= tmpMatch) continue;
            firstPart = false;
            bestMatch = tmpMatch;
            bestPartialArchive = archive;
        }
        if (!firstFull) {
            archive = bestFullArchive;
        } else if (!firstPart) {
            archive = bestPartialArchive;
        }
        return archive;
    }

    public void printInfo(PrintStream s, NumberFormat numberFormat) {
        s.print("filename = \"");
        s.print(this.name);
        s.println("\"");
        s.print("rrd_version = \"");
        s.print(this.header.version);
        s.println("\"");
        s.print("step = ");
        s.println(this.header.pdpStep);
        s.print("last_update = ");
        s.println(this.lastUpdate.getTime() / 1000L);
        Iterator i = this.dataSources.iterator();
        while (i.hasNext()) {
            DataSource ds = (DataSource)i.next();
            ds.printInfo(s, numberFormat);
        }
        int index = 0;
        Iterator i2 = this.archives.iterator();
        while (i2.hasNext()) {
            Archive archive = (Archive)i2.next();
            archive.printInfo(s, numberFormat, index++);
        }
    }

    public void toXml(PrintStream s) {
        int i;
        s.println("<!--");
        s.println("  -- Round Robin RRDatabase Dump ");
        s.println("  -- Generated by jRRD <ciaran@codeloop.com>");
        s.println("  -->");
        s.println("<rrd>");
        s.print("\t<version> ");
        s.print(this.header.version);
        s.println(" </version>");
        s.print("\t<step> ");
        s.print(this.header.pdpStep);
        s.println(" </step> <!-- Seconds -->");
        s.print("\t<lastupdate> ");
        s.print(this.lastUpdate.getTime() / 1000L);
        s.print(" </lastupdate> <!-- ");
        s.print(this.lastUpdate.toString());
        s.println(" -->");
        s.println();
        for (i = 0; i < this.header.dsCount; ++i) {
            DataSource ds = (DataSource)this.dataSources.get(i);
            ds.toXml(s);
        }
        s.println("<!-- Round Robin Archives -->");
        for (i = 0; i < this.header.rraCount; ++i) {
            Archive archive = (Archive)this.archives.get(i);
            archive.toXml(s);
        }
        s.println("</rrd>");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        sb.append(this.header.toString());
        Iterator i = this.dataSources.iterator();
        while (i.hasNext()) {
            DataSource ds = (DataSource)i.next();
            sb.append("\n\t");
            sb.append(ds.toString());
        }
        i = this.archives.iterator();
        while (i.hasNext()) {
            Archive archive = (Archive)i.next();
            sb.append("\n\t");
            sb.append(archive.toString());
        }
        return sb.toString();
    }
}

