/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource xmlInputSource) throws IOException, RrdException {
        super(xmlInputSource);
    }

    public RrdDefTemplate(String xmlString) throws IOException, RrdException {
        super(xmlString);
    }

    public RrdDefTemplate(File xmlFile) throws IOException, RrdException {
        super(xmlFile);
    }

    public RrdDef getRrdDef() throws RrdException {
        if (!this.root.getTagName().equals("rrd_def")) {
            throw new RrdException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String path = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(path);
        try {
            String startStr = this.getChildValue(this.root, "start");
            GregorianCalendar startGc = Util.getGregorianCalendar(startStr);
            rrdDef.setStartTime(startGc);
        }
        catch (RrdException e) {
            // empty catch block
        }
        try {
            long step = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(step);
        }
        catch (RrdException e) {
            // empty catch block
        }
        Node[] dsNodes = RrdDefTemplate.getChildNodes(this.root, "datasource");
        for (int i = 0; i < dsNodes.length; ++i) {
            this.validateTagsOnlyOnce(dsNodes[i], new String[]{"name", "type", "heartbeat", "min", "max"});
            String name = this.getChildValue(dsNodes[i], "name");
            String type = this.getChildValue(dsNodes[i], "type");
            long heartbeat = this.getChildValueAsLong(dsNodes[i], "heartbeat");
            double min = this.getChildValueAsDouble(dsNodes[i], "min");
            double max = this.getChildValueAsDouble(dsNodes[i], "max");
            rrdDef.addDatasource(name, type, heartbeat, min, max);
        }
        Node[] arcNodes = RrdDefTemplate.getChildNodes(this.root, "archive");
        for (int i = 0; i < arcNodes.length; ++i) {
            this.validateTagsOnlyOnce(arcNodes[i], new String[]{"cf", "xff", "steps", "rows"});
            String consolFun = this.getChildValue(arcNodes[i], "cf");
            double xff = this.getChildValueAsDouble(arcNodes[i], "xff");
            int steps = this.getChildValueAsInt(arcNodes[i], "steps");
            int rows = this.getChildValueAsInt(arcNodes[i], "rows");
            rrdDef.addArchive(consolFun, xff, steps, rows);
        }
        return rrdDef;
    }
}

