/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.TimeMarker;

public class TimeAxisUnit {
    private static final int[] calendarUnit = new int[]{13, 12, 11, 5, 3, 2, 1};
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    private static final String[] UNIT_NAMES = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR"};
    private static final String[] DAY_NAMES = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
    private int minGridTimeUnit = 2;
    private int minGridUnitSteps = 1;
    private int majGridTimeUnit = 2;
    private int majGridUnitSteps = 6;
    private boolean centerLabels = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
    private int firstDayOfWeek = 2;

    TimeAxisUnit(int minGridTimeUnit, int minGridUnitSteps, int majGridTimeUnit, int majGridUnitSteps, SimpleDateFormat dateFormat, boolean centerLabels, int firstDayOfWeek) {
        this.minGridTimeUnit = minGridTimeUnit;
        this.minGridUnitSteps = minGridUnitSteps;
        this.majGridTimeUnit = majGridTimeUnit;
        this.majGridUnitSteps = majGridUnitSteps;
        this.dateFormat = new SimpleDateFormat(dateFormat.toPattern(), Locale.ENGLISH);
        this.centerLabels = centerLabels;
        this.firstDayOfWeek = firstDayOfWeek;
    }

    TimeMarker[] getTimeMarkers(long start, long stop) {
        stop *= 1000L;
        Calendar cMaj = Calendar.getInstance();
        Calendar cMin = Calendar.getInstance();
        this.setStartPoint(cMaj, this.majGridTimeUnit, start *= 1000L);
        this.setStartPoint(cMin, this.minGridTimeUnit, start);
        long minPoint = cMin.getTimeInMillis();
        long majPoint = cMaj.getTimeInMillis();
        while (majPoint < start) {
            majPoint = this.getNextPoint(cMaj, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        while (minPoint < start) {
            minPoint = this.getNextPoint(cMin, this.minGridTimeUnit, this.minGridUnitSteps);
        }
        ArrayList<TimeMarker> markerList = new ArrayList<TimeMarker>();
        while (minPoint <= stop && majPoint <= stop) {
            if (minPoint < majPoint) {
                markerList.add(new TimeMarker(minPoint, "", false));
                minPoint = this.getNextPoint(cMin, this.minGridTimeUnit, this.minGridUnitSteps);
                continue;
            }
            if (minPoint == majPoint) {
                markerList.add(new TimeMarker(majPoint, this.dateFormat.format(cMaj.getTime()), true));
                majPoint = this.getNextPoint(cMaj, this.majGridTimeUnit, this.majGridUnitSteps);
                minPoint = this.getNextPoint(cMin, this.minGridTimeUnit, this.minGridUnitSteps);
                continue;
            }
            markerList.add(new TimeMarker(majPoint, this.dateFormat.format(cMaj.getTime()), true));
            majPoint = this.getNextPoint(cMaj, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        while (minPoint <= stop) {
            markerList.add(new TimeMarker(minPoint, "", false));
            minPoint = this.getNextPoint(cMin, this.minGridTimeUnit, this.minGridUnitSteps);
        }
        while (majPoint <= stop) {
            markerList.add(new TimeMarker(majPoint, this.dateFormat.format(cMaj.getTime()), true));
            majPoint = this.getNextPoint(cMaj, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        return markerList.toArray(new TimeMarker[0]);
    }

    long getMajorGridWidth() {
        Calendar c = Calendar.getInstance();
        long now = c.getTimeInMillis() / 1000L;
        c.add(calendarUnit[this.majGridTimeUnit], this.majGridUnitSteps);
        return c.getTimeInMillis() / 1000L - now;
    }

    boolean getCenterLabels() {
        return this.centerLabels;
    }

    int getMinGridTimeUnit() {
        return this.minGridTimeUnit;
    }

    int getMinGridUnitSteps() {
        return this.minGridUnitSteps;
    }

    int getMajGridTimeUnit() {
        return this.majGridTimeUnit;
    }

    int getMajGridUnitSteps() {
        return this.majGridUnitSteps;
    }

    boolean isCenterLabels() {
        return this.centerLabels;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void setStartPoint(Calendar t, int unit, long exactStart) {
        t.setTimeInMillis(exactStart);
        t.setFirstDayOfWeek(this.firstDayOfWeek);
        for (int i = 0; i < 2 && i <= unit; ++i) {
            t.set(calendarUnit[i], 0);
        }
        if (unit >= 2) {
            t.set(11, 0);
        }
        if (unit == 4) {
            t.set(7, t.getFirstDayOfWeek());
        } else if (unit == 5) {
            t.set(5, 1);
        } else if (unit == 6) {
            t.set(5, 1);
            t.set(2, 0);
        }
    }

    private long getNextPoint(Calendar t, int unit, int unitSteps) {
        t.add(calendarUnit[unit], unitSteps);
        return t.getTimeInMillis();
    }

    static String getUnitName(int unit) {
        return UNIT_NAMES[unit];
    }

    static String getDayName(int dayIndex) {
        return DAY_NAMES[dayIndex];
    }

    void exportXmlTemplate(XmlWriter xml) {
        xml.startTag("time_axis");
        xml.writeTag("min_grid_time_unit", TimeAxisUnit.getUnitName(this.getMinGridTimeUnit()));
        xml.writeTag("min_grid_unit_steps", this.getMinGridUnitSteps());
        xml.writeTag("maj_grid_time_unit", TimeAxisUnit.getUnitName(this.getMajGridTimeUnit()));
        xml.writeTag("maj_grid_unit_steps", this.getMajGridUnitSteps());
        xml.writeTag("date_format", this.getDateFormat().toPattern());
        xml.writeTag("center_labels", this.getCenterLabels());
        if (this.firstDayOfWeek != 2) {
            xml.writeTag("first_day_of_week", TimeAxisUnit.getDayName(this.firstDayOfWeek));
        }
        xml.closeTag();
    }
}

