/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.graph.ValueFormatter;

class Print {
    private static final String SCALE_MARKER = "@s";
    private static final String UNIFORM_SCALE_MARKER = "@S";
    private static final String VALUE_MARKER = "@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})";
    private static final Pattern VALUE_PATTERN = Pattern.compile("@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})");
    private int numDec = 3;
    private int strLen = -1;
    private boolean normalScale = false;
    private boolean uniformScale = false;
    private ValueFormatter vFormat;

    Print(double defaultBase, int scaleIndex) {
        this.vFormat = new ValueFormatter(defaultBase, scaleIndex);
    }

    String getFormattedString(double value, String format, double baseValue) throws RrdException {
        this.checkValuePlacement(format);
        double oldBase = this.vFormat.getBase();
        this.vFormat.setBase(baseValue);
        this.vFormat.setFormat(value, this.numDec, this.strLen);
        this.vFormat.setScaling(this.normalScale, this.uniformScale);
        String valueStr = this.vFormat.getFormattedValue();
        String prefix = this.vFormat.getPrefix();
        this.vFormat.setBase(oldBase);
        String str = format;
        str = str.replaceAll(VALUE_MARKER, valueStr);
        if (this.normalScale) {
            str = str.replaceAll(SCALE_MARKER, prefix);
        }
        if (this.uniformScale) {
            str = str.replaceAll(UNIFORM_SCALE_MARKER, prefix);
        }
        return str;
    }

    private void checkValuePlacement(String text) throws RrdException {
        Matcher m = VALUE_PATTERN.matcher(text);
        if (m.find()) {
            this.normalScale = text.indexOf(SCALE_MARKER) >= 0;
            boolean bl = this.uniformScale = text.indexOf(UNIFORM_SCALE_MARKER) >= 0;
            if (this.normalScale && this.uniformScale) {
                throw new RrdException("Can't specify normal scaling and uniform scaling at the same time.");
            }
            String[] group = m.group(1).split("\\.");
            this.strLen = -1;
            this.numDec = 0;
            if (group.length > 1) {
                if (group[0].length() > 0) {
                    this.strLen = Integer.parseInt(group[0]);
                    this.numDec = Integer.parseInt(group[1]);
                } else {
                    this.numDec = Integer.parseInt(group[1]);
                }
            } else {
                this.numDec = Integer.parseInt(group[0]);
            }
        } else {
            throw new RrdException("Could not find where to place value. No @ placeholder found.");
        }
    }
}

