/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraphDef;

public class RrdtoolGraph {
    private static final int SAVE_PNG = 0;
    private static final int SAVE_GIF = 1;
    private static final int DS_DEF = 0;
    private static final int DS_CDEF = 1;
    private static final int TXT_COMMENT = 0;
    private static final int TXT_GPRINT = 1;
    private static final int GRAPH_LINE = 0;
    private static final int GRAPH_AREA = 1;
    private static final int GRAPH_STACK = 2;
    private static final int TKN_IGNORE = -2;
    private static final int TKN_UNKNOWN = -1;
    private static final int TKN_RRDTOOL = 0;
    private static final int TKN_GRAPH = 1;
    private static final int TKN_START = 2;
    private static final int TKN_END = 3;
    private static final int TKN_COMMENT = 4;
    private static final int TKN_LINE = 5;
    private static final int TKN_AREA = 6;
    private static final int TKN_STACK = 7;
    private static final int TKN_CDEF = 8;
    private static final int TKN_DEF = 9;
    private static final int TKN_GPRINT = 11;
    private static final int TKN_HRULE = 12;
    private static final int TKN_VRULE = 13;
    private static final int TKN_STEP = 14;
    private static final int TKN_TITLE = 15;
    private static final int TKN_NOLEGEND = 16;
    private static final int TKN_COLOR = 17;
    private static final int TKN_RIGID = 18;
    private static final int TKN_LOWERLIMIT = 19;
    private static final int TKN_UPPERLIMIT = 20;
    private static final int TKN_LAZY = 21;
    private static final int TKN_OVERLAY = 23;
    private static final int TKN_BACKGROUND = 24;
    private static final int TKN_IMGFORMAT = 25;
    private static final int TKN_WIDTH = 26;
    private static final int TKN_HEIGHT = 27;
    private static final int TKN_VERT_LABEL = 28;
    private static final int TKN_UNITS_EXP = 29;
    private static final int TKN_NOMINOR = 30;
    private static final int TKN_XGRID = 31;
    private static final int TKN_YGRID = 32;
    private static final int TKN_BASE = 33;
    private String token = "";
    private String script = null;
    private RrdGraphDef graphDef = null;
    private int tokenPos = 0;
    private char[] parseCmd = new char[0];
    private boolean gridRigid = false;
    private double gridLower = Double.MAX_VALUE;
    private double gridUpper = Double.MIN_VALUE;
    private int width = 0;
    private int height = 0;
    private int fileType = 0;
    private String fileName = "";

    public RrdtoolGraph(String script) {
        this.script = script;
    }

    public RrdGraphDef getRrdGraphDef() throws RrdException {
        this.parseRrdtoolScript();
        return this.graphDef;
    }

    private boolean parseRrdtoolScript() throws RrdException {
        long startTime = 0L;
        long stopTime = 0L;
        this.graphDef = new RrdGraphDef();
        this.parseCmd = this.script.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').toCharArray();
        while (this.nextToken() > 0) {
            System.err.println(this.token);
            switch (this.parseToken(this.token)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.nextToken();
                    break;
                }
                case 2: {
                    this.nextToken();
                    startTime = Long.parseLong(this.token);
                    break;
                }
                case 3: {
                    this.nextToken();
                    stopTime = Long.parseLong(this.token);
                    break;
                }
                case 30: {
                    this.graphDef.setMinorGridX(false);
                    this.graphDef.setMinorGridY(false);
                    break;
                }
                case 26: {
                    this.nextToken();
                    this.width = Integer.parseInt(this.token);
                    break;
                }
                case 27: {
                    this.nextToken();
                    this.height = Integer.parseInt(this.token);
                    break;
                }
                case 29: {
                    this.nextToken();
                    this.graphDef.setUnitsExponent(Integer.parseInt(this.token));
                    break;
                }
                case 28: {
                    this.nextToken();
                    this.graphDef.setVerticalLabel(this.unescape(this.token));
                    break;
                }
                case 15: {
                    this.nextToken();
                    this.graphDef.setTitle(this.unescape(this.token));
                    break;
                }
                case 25: {
                    this.nextToken();
                    if (!this.token.equalsIgnoreCase("gif")) break;
                    this.fileType = 1;
                    break;
                }
                case 24: {
                    this.nextToken();
                    this.graphDef.setBackground(this.unescape(this.token));
                    break;
                }
                case 23: {
                    this.nextToken();
                    this.graphDef.setOverlay(this.unescape(this.token));
                    break;
                }
                case 16: {
                    this.graphDef.setShowLegend(false);
                    break;
                }
                case 19: {
                    this.nextToken();
                    this.gridLower = Double.parseDouble(this.token);
                    break;
                }
                case 20: {
                    this.nextToken();
                    this.gridUpper = Double.parseDouble(this.token);
                    break;
                }
                case 18: {
                    this.gridRigid = true;
                    break;
                }
                case 33: {
                    this.nextToken();
                    this.graphDef.setBaseValue(Double.parseDouble(this.token));
                    break;
                }
                case 4: {
                    this.parseTextCommand(0);
                    break;
                }
                case 11: {
                    this.parseTextCommand(1);
                    break;
                }
                case 5: {
                    this.parseGraphCommand(0);
                    break;
                }
                case 6: {
                    this.parseGraphCommand(1);
                    break;
                }
                case 7: {
                    this.parseGraphCommand(2);
                    break;
                }
                case 9: {
                    this.parseDatasource(0);
                    break;
                }
                case 8: {
                    this.parseDatasource(1);
                    break;
                }
                case -2: {
                    break;
                }
                case -1: {
                    throw new RrdException("Unknown token: " + this.token);
                }
            }
        }
        if (this.gridRigid || this.gridLower == Double.MAX_VALUE || this.gridUpper == Double.MIN_VALUE) {
            this.graphDef.setGridRange(this.gridLower, this.gridUpper, this.gridRigid);
        }
        return true;
    }

    private void parseGraphCommand(int type) throws RrdException {
        if (type == 0) {
            int w = Integer.parseInt("" + this.token.charAt(4));
            int pos = this.token.indexOf(35, 6);
            int npos = this.token.indexOf(58, 6);
            if (pos < 0) {
                pos = npos;
            }
            String ds = pos > 0 ? this.token.substring(6, pos) : this.token.substring(6);
            Color color = null;
            String legend = null;
            if (pos > 0 && this.token.charAt(pos) == '#') {
                color = Color.decode(npos > 0 ? this.token.substring(pos, npos) : this.token.substring(pos));
            }
            if (npos > 0) {
                legend = this.unescape(this.token.substring(npos + 1));
            }
            this.graphDef.line(ds, color, legend, w);
        } else {
            this.token = type == 2 ? this.token.substring(6) : this.token.substring(5);
            int pos = this.token.indexOf(35);
            int npos = this.token.indexOf(58);
            String ds = pos > 0 ? this.token.substring(0, pos) : this.token.substring(0);
            Color color = null;
            String legend = null;
            if (pos > 0 && this.token.charAt(pos) == '#') {
                color = Color.decode(npos > 0 ? this.token.substring(pos, npos) : this.token.substring(pos));
            }
            if (npos > 0) {
                legend = this.unescape(this.token.substring(npos + 1));
            }
            if (type == 1) {
                this.graphDef.area(ds, color, legend);
            } else if (type == 2) {
                this.graphDef.stack(ds, color, legend);
            }
        }
    }

    private String unescape(String text) {
        if (text.startsWith("'") || text.startsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private void parseTextCommand(int type) throws RrdException {
        int pos = this.token.indexOf(58);
        if (type == 0) {
            String text = this.unescape(this.token.substring(pos + 1));
            this.graphDef.comment(text);
        } else if (type == 1) {
            int npos = this.token.indexOf(58, ++pos);
            String ds = this.token.substring(pos, npos);
            pos = this.token.indexOf(58, ++npos);
            String cf = this.token.substring(npos, pos);
            String text = this.unescape(this.token.substring(pos + 1));
        }
    }

    private void parseDatasource(int type) throws RrdException {
        int pos = this.token.indexOf(58);
        int npos = this.token.indexOf(61, ++pos);
        String name = this.token.substring(pos, npos);
        if (type == 0) {
            this.token = this.token.substring(npos + 1);
            pos = this.token.lastIndexOf(58);
            String cf = this.token.substring(pos + 1);
            npos = this.token.lastIndexOf(58, pos - 1);
            String dsName = this.token.substring(npos + 1, pos);
            String rrdFile = this.token.substring(0, npos);
            this.graphDef.datasource(name, rrdFile, dsName, cf);
        } else {
            this.graphDef.datasource(name, this.token.substring(npos + 1));
        }
    }

    private int nextToken() {
        char[] tknChars = new char[512];
        int charPos = 0;
        int cmdPos = this.tokenPos;
        boolean found = false;
        boolean stringComplete = true;
        int findChar = 32;
        while (charPos < 512 && cmdPos < this.parseCmd.length && !found) {
            if (this.parseCmd[cmdPos] == '\"') {
                if (stringComplete) {
                    stringComplete = false;
                    findChar = 34;
                } else if (findChar == 34 && this.parseCmd[cmdPos - 1] != '\\') {
                    stringComplete = true;
                }
            } else if (this.parseCmd[cmdPos] == '\'') {
                if (stringComplete) {
                    stringComplete = false;
                    findChar = 39;
                } else if (findChar == 39 && this.parseCmd[cmdPos - 1] != '\\') {
                    stringComplete = true;
                }
            }
            if (stringComplete && this.parseCmd[cmdPos] == ' ') {
                found = true;
                continue;
            }
            tknChars[charPos++] = this.parseCmd[cmdPos++];
        }
        this.token = new String(tknChars, 0, charPos).trim();
        this.tokenPos = cmdPos + 1;
        return charPos;
    }

    private int parseToken(String token) {
        if (token.equalsIgnoreCase("rrdtool")) {
            return 0;
        }
        if (token.equalsIgnoreCase("graph")) {
            return 1;
        }
        if (token.equalsIgnoreCase("--start") || token.equals("-s")) {
            return 2;
        }
        if (token.equalsIgnoreCase("--end") || token.equals("-e")) {
            return 3;
        }
        if (token.equalsIgnoreCase("--width") || token.equals("-w")) {
            return 26;
        }
        if (token.equalsIgnoreCase("--height") || token.equals("-h")) {
            return 27;
        }
        if (token.equalsIgnoreCase("--no-minor")) {
            return 30;
        }
        if (token.equalsIgnoreCase("--units-exponent") || token.equals("-X")) {
            return 29;
        }
        if (token.equalsIgnoreCase("--vertical-label") || token.equals("-v")) {
            return 28;
        }
        if (token.equalsIgnoreCase("--imgformat") || token.equals("-a")) {
            return 25;
        }
        if (token.equalsIgnoreCase("--background") || token.equals("-B")) {
            return 24;
        }
        if (token.equalsIgnoreCase("--overlay") || token.equals("-O")) {
            return 23;
        }
        if (token.equalsIgnoreCase("--title") || token.equals("-t")) {
            return 15;
        }
        if (token.equalsIgnoreCase("--step") || token.equals("-S")) {
            return 14;
        }
        if (token.equalsIgnoreCase("--no-legend") || token.equals("-g")) {
            return 16;
        }
        if (token.equalsIgnoreCase("--base") || token.equals("-b")) {
            return 33;
        }
        if (token.equalsIgnoreCase("--lower-limit") || token.equals("-l")) {
            return 19;
        }
        if (token.equalsIgnoreCase("--upper-limit") || token.equals("-u")) {
            return 20;
        }
        if (token.equalsIgnoreCase("--rigid") || token.equals("-r")) {
            return 18;
        }
        if (token.startsWith("COMMENT")) {
            return 4;
        }
        if (token.startsWith("GPRINT")) {
            return 11;
        }
        if (token.startsWith("LINE")) {
            return 5;
        }
        if (token.startsWith("AREA")) {
            return 6;
        }
        if (token.startsWith("STACK")) {
            return 7;
        }
        if (token.startsWith("HRULE")) {
            return 12;
        }
        if (token.startsWith("VRULE")) {
            return 13;
        }
        if (token.startsWith("CDEF")) {
            return 8;
        }
        if (token.startsWith("DEF")) {
            return 9;
        }
        if (token.equals("-Y") || token.equals("--alt-y-grid") || token.equals("-R") || token.equals("--alt-y-mrtg") || token.equals("-A") || token.equals("--alt-autoscale") || token.equals("-M") || token.equals("--alt-autoscale-max") || token.equals("-L") || token.equals("--units-length") || token.equals("-i") || token.equals("--interlaced") || token.equals("-f") || token.equals("--imginfo") || token.equals("-o") || token.equals("--logarithmic") || token.equals("-j") || token.equals("--only-graph") || token.equals("-F") || token.equals("--force-rules-legend") || token.startsWith("PRINT") || token.equals("-U") || token.startsWith("--unit")) {
            return -2;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        String str = "rrdtool graph FNAME --start 100 --end 700\nDEF:inOctets=c:/file.rrd:test-run:AVERAGE CDEF:bitIn=inOctets,8,* COMMENT:'commentaar \"nr\" 1'\nAREA:test#ffa9b3:'this is the legend'\nCOMMENT:\"commentaar 'nr' 2\"\nLINE2:test2:'this is the legend two' GPRINT:bitIn:AVG:'Average %2.5'";
        RrdtoolGraph rg = new RrdtoolGraph(str);
        rg.getRrdGraphDef();
    }
}

