/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Comment;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueFormatter;

class Gprint
extends Comment {
    private static final String SCALE_MARKER = "@s";
    private static final String UNIFORM_SCALE_MARKER = "@S";
    private static final String VALUE_MARKER = "@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})";
    private static final Pattern VALUE_PATTERN = Pattern.compile("@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})");
    private String sourceName;
    private int aggregate;
    private int numDec = 3;
    private int strLen = -1;
    private double baseValue = -1.0;
    private boolean normalScale = false;
    private boolean uniformScale = false;
    protected ArrayList parsedList;

    Gprint(String sourceName, String consolFunc, String text) throws RrdException {
        this.text = text;
        this.checkValuePlacement();
        this.commentType = 2;
        this.sourceName = sourceName;
        if (consolFunc.equalsIgnoreCase("AVERAGE") || consolFunc.equalsIgnoreCase("AVG")) {
            this.aggregate = 2;
        } else if (consolFunc.equalsIgnoreCase("MAX") || consolFunc.equalsIgnoreCase("MAXIMUM")) {
            this.aggregate = 1;
        } else if (consolFunc.equalsIgnoreCase("MIN") || consolFunc.equalsIgnoreCase("MINIMUM")) {
            this.aggregate = 0;
        } else if (consolFunc.equalsIgnoreCase("LAST")) {
            this.aggregate = 4;
        } else if (consolFunc.equalsIgnoreCase("FIRST")) {
            this.aggregate = 3;
        } else if (consolFunc.equalsIgnoreCase("TOTAL")) {
            this.aggregate = 5;
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
    }

    Gprint(String sourceName, String consolFunc, String text, double base) throws RrdException {
        this(sourceName, consolFunc, text);
        this.baseValue = base;
    }

    void setValue(Source[] sources, HashMap sourceIndex, ValueFormatter vFormat) throws RrdException {
        try {
            double value = sources[(Integer)sourceIndex.get(this.sourceName)].getAggregate(this.aggregate);
            double oldBase = vFormat.getBase();
            if (this.baseValue != -1.0 && this.baseValue != vFormat.getBase()) {
                vFormat.setBase(this.baseValue);
            }
            vFormat.setFormat(value, this.numDec, this.strLen);
            vFormat.setScaling(this.normalScale, this.uniformScale);
            String valueStr = vFormat.getFormattedValue();
            String prefix = vFormat.getPrefix();
            this.parsedList = new ArrayList(this.oList);
            for (int i = 0; i < this.oList.size(); i += 2) {
                String str = (String)this.oList.get(i);
                str = str.replaceAll(VALUE_MARKER, valueStr);
                if (this.normalScale) {
                    str = str.replaceAll(SCALE_MARKER, prefix);
                }
                if (this.uniformScale) {
                    str = str.replaceAll(UNIFORM_SCALE_MARKER, prefix);
                }
                this.parsedList.set(i, str);
            }
            if (this.baseValue != -1.0) {
                vFormat.setBase(oldBase);
            }
        }
        catch (Exception e) {
            throw new RrdException("Could not find datasource: " + this.sourceName);
        }
    }

    ArrayList getTokens() {
        return this.parsedList;
    }

    private void checkValuePlacement() throws RrdException {
        Matcher m = VALUE_PATTERN.matcher(this.text);
        if (m.find()) {
            this.normalScale = this.text.indexOf(SCALE_MARKER) >= 0;
            boolean bl = this.uniformScale = this.text.indexOf(UNIFORM_SCALE_MARKER) >= 0;
            if (this.normalScale && this.uniformScale) {
                throw new RrdException("Can't specify normal scaling and uniform scaling at the same time.");
            }
            String[] group = m.group(1).split("\\.");
            this.strLen = -1;
            this.numDec = 0;
            if (group.length > 1) {
                if (group[0].length() > 0) {
                    this.strLen = Integer.parseInt(group[0]);
                    this.numDec = Integer.parseInt(group[1]);
                } else {
                    this.numDec = Integer.parseInt(group[1]);
                }
            } else {
                this.numDec = Integer.parseInt(group[0]);
            }
        } else {
            throw new RrdException("Could not find where to place value. No @ placeholder found.");
        }
    }

    void exportXmlTemplate(XmlWriter xml) {
        xml.startTag("gprint");
        xml.writeTag("datasource", this.sourceName);
        xml.writeTag("cf", Source.aggregates[this.aggregate]);
        xml.writeTag("format", this.text);
        if (this.baseValue != -1.0) {
            xml.writeTag("base", this.baseValue);
        }
        xml.closeTag();
    }
}

