/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.impl.ExecuteQuery;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultProcessor
implements Processor {
    protected static final String BLANK = "";
    protected static final String PATH_ROOT = "/";
    protected static final String PATH_EXEC = "/exec";
    protected static final String PATH_INTERFACE = "/interface/";
    protected static final String PATH_TEST = "test/";
    protected static final String PATH_UP = "..";
    protected static final String FILE_INDEX = "index.html";
    protected static final String FILE_UTIL = "util.js";
    protected static final String FILE_ENGINE = "engine.js";
    protected static final String FILE_DEPRECATED = "deprecated.js";
    protected static final String FILE_HELP = "help.html";
    protected static final String EXTENSION_JS = ".js";
    protected static final String MIME_XML = "text/xml";
    protected static final String MIME_HTML = "text/html";
    protected static final String MIME_JS = "text/javascript";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private int compressionLevel = 7;
    private JavascriptUtil jsutil = new JavascriptUtil();
    private boolean allowImpossibleTests = false;
    private boolean scriptCompressed = true;
    protected CreatorManager creatorManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    protected final Map scriptCache = new HashMap();
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.impl.DefaultProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathinfo = req.getPathInfo();
        if (pathinfo == null || pathinfo.length() == 0 || pathinfo.equals(PATH_ROOT)) {
            resp.sendRedirect(String.valueOf(req.getContextPath()) + req.getServletPath() + '/' + FILE_INDEX);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/index.html")) {
            this.doIndex(req, resp);
        } else if (pathinfo != null && pathinfo.startsWith("/test/")) {
            this.doTest(req, resp);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/engine.js")) {
            this.doFile(resp, FILE_ENGINE, MIME_JS);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/util.js")) {
            this.doFile(resp, FILE_UTIL, MIME_JS);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/deprecated.js")) {
            this.doFile(resp, FILE_DEPRECATED, MIME_JS);
        } else if (pathinfo != null && pathinfo.startsWith(PATH_INTERFACE)) {
            this.doInterface(req, resp);
        } else if (pathinfo != null && pathinfo.startsWith(PATH_EXEC)) {
            this.doExec(req, resp);
        } else {
            log.warn("Page not found. In debug/test mode try viewing /[WEB-APP]/dwr/");
            resp.sendError(404);
        }
    }

    protected void doIndex(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access index page outside of debug mode. Set the debug init-parameter to true to enable.");
            resp.sendError(403);
        }
        resp.setContentType(MIME_HTML);
        PrintWriter out = resp.getWriter();
        out.println("<html>");
        out.println("<head><title>DWR Test Index</title></head>");
        out.println("<body>");
        out.println("<h2>Classes known to DWR:</h2>");
        out.println("<ul>");
        Iterator it = this.creatorManager.getCreatorNames().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Creator creator = this.creatorManager.getCreator(name);
            out.println("<li><a href='test/" + name + "'>" + name + "</a> (" + creator.getType().getName() + ")</li>");
        }
        out.println("</ul>");
        out.println("<h2>Other Links</h2>");
        out.println("<ul>");
        out.println("<li>Up to <a href='" + req.getContextPath() + "/'>top level of web app</a>.</li>");
        out.println("</ul>");
        out.println("</body></html>");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doTest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.creatorManager.isDebug()) {
            DefaultProcessor.log.warn("Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            resp.sendError(403);
            return;
        }
        scriptname = req.getPathInfo();
        scriptname = LocalUtil.replace(scriptname, "/test/", "");
        scriptname = LocalUtil.replace(scriptname, "/", "");
        creator = this.creatorManager.getCreator(scriptname);
        methods = creator.getType().getMethods();
        resp.setContentType("text/html");
        out = resp.getWriter();
        interfaceURL = String.valueOf(req.getContextPath()) + req.getServletPath() + "/interface/" + scriptname + ".js";
        engineURL = String.valueOf(req.getContextPath()) + req.getServletPath() + '/' + "engine.js";
        utilURL = String.valueOf(req.getContextPath()) + req.getServletPath() + '/' + "util.js";
        proxyInterfaceURL = "../interface/" + scriptname + ".js";
        proxyEngineURL = "../engine.js";
        proxyUtilURL = "../util.js";
        out.println("<html>");
        out.println("<head>");
        out.println("  <title>DWR Test</title>");
        out.println("  <!-- These paths use .. so that they still work behind a path mapping proxy. The fully qualified version is more cut and paste friendly. -->");
        out.println("  <script type='text/javascript' src='" + proxyInterfaceURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyEngineURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyUtilURL + "'></script>");
        out.println("  <script type='text/javascript'>");
        out.println("  function objectEval(text)");
        out.println("  {");
        out.println("    // eval() breaks when we use it to get an object using the { a:42, b:'x' }");
        out.println("    // syntax because it thinks that { and } surround a block and not an object");
        out.println("    // So we wrap it in an array and extract the first element to get around");
        out.println("    // this.");
        out.println("    // The regex = [start of line][whitespace]{[stuff]}[whitespace][end of line]");
        out.println("    text = text.replace(/\\n/g, ' ');");
        out.println("    text = text.replace(/\\r/g, ' ');");
        out.println("    if (text.match(/^\\s*\\{.*\\}\\s*$/))");
        out.println("    {");
        out.println("      text = '[' + text + '][0]';");
        out.println("    }");
        out.println("    return eval(text);");
        out.println("  }");
        out.println("  </script>");
        out.println("  <style>");
        out.println("    input.itext { font-size: smaller; background: #E4E4E4; border: 0; }");
        out.println("    input.ibutton { font-size: xx-small; border: 1px outset; margin: 0px; padding: 0px; }");
        out.println("    span.reply { background: #ffffdd; white-space: pre; }");
        out.println("    span.warning { font-size: smaller; color: red; }");
        out.println("  </style>");
        out.println("</head>");
        out.println("<body onload='DWRUtil.useLoadingMessage()'>");
        out.println("");
        out.println("<h2>Methods For: " + scriptname + " (" + creator.getType().getName() + ")</h2>");
        out.println("<p>To use this class in your javascript you will need the following script includes:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + interfaceURL + "'>" + interfaceURL + "</a>'&gt;&lt;/script&gt;");
        out.println("  &lt;script type='text/javascript' src='<a href='" + engineURL + "'>" + engineURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>In addition there is an optional utility script:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + utilURL + "'>" + utilURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>Replies from DWR are shown with a yellow background if they are simple or in an alert box otherwise.<br/>");
        out.println("The inputs are evaluated as Javascript so strings must be quoted before execution.</p>");
        out.println("<p>There are " + methods.length + " declared methods:</p><ul>");
        i = 0;
        while (i < methods.length) {
            block53: {
                block54: {
                    block52: {
                        method = methods[i];
                        methodName = method.getName();
                        reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
                        if (reason == null) break block52;
                        out.println("");
                        out.println("<li style='color: #A88;'>  " + methodName + "() is not available: " + reason + "</li>");
                        if (!this.allowImpossibleTests) break block53;
                    }
                    if (!this.jsutil.isReservedWord(methodName)) break block54;
                    out.println("");
                    out.println("<li style='color: #88A;'>" + methodName + "() is not available because it is a reserved word.</li>");
                    break block53;
                }
                out.println("");
                out.println("<li>");
                out.println("  " + methodName + '(');
                paramTypes = method.getParameterTypes();
                j = 0;
                while (j < paramTypes.length) {
                    block56: {
                        block58: {
                            block63: {
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                block57: {
                                                    block55: {
                                                        paramType = paramTypes[j];
                                                        if (!this.isAutoFilled(paramType)) break block55;
                                                        out.print("AUTO");
                                                        break block56;
                                                    }
                                                    value = "";
                                                    v0 = DefaultProcessor.class$1;
                                                    if (v0 == null) {
                                                        try {
                                                            v0 = Class.forName("java.lang.String");
                                                        }
                                                        catch (ClassNotFoundException v1) {
                                                            throw new NoClassDefFoundError(v1.getMessage());
                                                        }
                                                    }
                                                    if (paramType != v0) break block57;
                                                    value = "\"\"";
                                                    break block58;
                                                }
                                                v2 = DefaultProcessor.class$2;
                                                if (v2 == null) {
                                                    try {
                                                        v2 = Class.forName("java.lang.Boolean");
                                                    }
                                                    catch (ClassNotFoundException v3) {
                                                        throw new NoClassDefFoundError(v3.getMessage());
                                                    }
                                                }
                                                if (paramType != v2 && paramType != Boolean.TYPE) break block59;
                                                value = "true";
                                                break block58;
                                            }
                                            v4 = DefaultProcessor.class$3;
                                            if (v4 == null) {
                                                try {
                                                    v4 = Class.forName("java.lang.Integer");
                                                }
                                                catch (ClassNotFoundException v5) {
                                                    throw new NoClassDefFoundError(v5.getMessage());
                                                }
                                            }
                                            if (paramType == v4 || paramType == Integer.TYPE) break block60;
                                            v6 = DefaultProcessor.class$4;
                                            if (v6 == null) {
                                                try {
                                                    v6 = Class.forName("java.lang.Short");
                                                }
                                                catch (ClassNotFoundException v7) {
                                                    throw new NoClassDefFoundError(v7.getMessage());
                                                }
                                            }
                                            if (paramType == v6 || paramType == Short.TYPE) break block60;
                                            v8 = DefaultProcessor.class$5;
                                            if (v8 == null) {
                                                try {
                                                    v8 = Class.forName("java.lang.Long");
                                                }
                                                catch (ClassNotFoundException v9) {
                                                    throw new NoClassDefFoundError(v9.getMessage());
                                                }
                                            }
                                            if (paramType == v8 || paramType == Long.TYPE) break block60;
                                            v10 = DefaultProcessor.class$6;
                                            if (v10 == null) {
                                                try {
                                                    v10 = Class.forName("java.lang.Byte");
                                                }
                                                catch (ClassNotFoundException v11) {
                                                    throw new NoClassDefFoundError(v11.getMessage());
                                                }
                                            }
                                            if (paramType != v10 && paramType != Byte.TYPE) break block61;
                                        }
                                        value = "0";
                                        break block58;
                                    }
                                    v12 = DefaultProcessor.class$7;
                                    if (v12 == null) {
                                        try {
                                            v12 = Class.forName("java.lang.Float");
                                        }
                                        catch (ClassNotFoundException v13) {
                                            throw new NoClassDefFoundError(v13.getMessage());
                                        }
                                    }
                                    if (paramType == v12 || paramType == Float.TYPE) break block62;
                                    v14 = DefaultProcessor.class$8;
                                    if (v14 == null) {
                                        try {
                                            v14 = Class.forName("java.lang.Double");
                                        }
                                        catch (ClassNotFoundException v15) {
                                            throw new NoClassDefFoundError(v15.getMessage());
                                        }
                                    }
                                    if (paramType != v14 && paramType != Double.TYPE) break block63;
                                }
                                value = "0.0";
                                break block58;
                            }
                            if (paramType.isArray()) ** GOTO lbl-1000
                            v16 = DefaultProcessor.class$9;
                            if (v16 == null) {
                                try {
                                    v16 = Class.forName("java.util.Collection");
                                }
                                catch (ClassNotFoundException v17) {
                                    throw new NoClassDefFoundError(v17.getMessage());
                                }
                            }
                            if (v16.isAssignableFrom(paramType)) lbl-1000:
                            // 2 sources

                            {
                                value = "[]";
                            } else {
                                v18 = DefaultProcessor.class$10;
                                if (v18 == null) {
                                    try {
                                        v18 = Class.forName("java.util.Map");
                                    }
                                    catch (ClassNotFoundException v19) {
                                        throw new NoClassDefFoundError(v19.getMessage());
                                    }
                                }
                                if (v18.isAssignableFrom(paramType)) {
                                    value = "{}";
                                }
                            }
                        }
                        out.print("    <input class='itext' type='text' size='10' value='" + value + "' id='p" + i + j + "' title='Will be converted to: " + paramType.getName() + "'/>");
                    }
                    out.println(j == paramTypes.length - 1 ? "" : ", ");
                    ++j;
                }
                out.println("  );");
                onclick = String.valueOf(scriptname) + '.' + methodName + "(reply" + i;
                j = 0;
                while (j < paramTypes.length) {
                    if (!this.isAutoFilled(paramTypes[j])) {
                        onclick = String.valueOf(onclick) + ",objectEval($(\"p" + i + j + "\").value)";
                    }
                    ++j;
                }
                onclick = String.valueOf(onclick) + ");";
                out.println("  <input class='ibutton' type='button' onclick='" + onclick + "' value='Execute'  title='Calls " + scriptname + '.' + methodName + "(). View source for details.'/>");
                out.println("  <script type='text/javascript'>");
                out.println("    var reply" + i + " = function(data)");
                out.println("    {");
                out.println("      if (data != null && typeof data == 'object') alert(DWRUtil.toDescriptiveString(data, 2));");
                out.println("      else DWRUtil.setValue('d" + i + "', DWRUtil.toDescriptiveString(data, 1));");
                out.println("    }");
                out.println("  </script>");
                out.println("  <span id='d" + i + "' class='reply'></span>");
                overloaded = false;
                j = 0;
                while (j < methods.length) {
                    if (j != i && methods[j].getName().equals(methodName)) {
                        overloaded = true;
                    }
                    ++j;
                }
                if (overloaded) {
                    out.println("<br/><span class='warning'>(Warning: overloaded methods are not recommended. See <a href='#overloadedMethod'>below</a>)</span>");
                }
                j = 0;
                while (j < paramTypes.length) {
                    if (!this.converterManager.isConvertable(paramTypes[j])) {
                        out.println("<br/><span class='warning'>(Warning: No Converter for " + paramTypes[j].getName() + ". See <a href='#missingConverter'>below</a>)</span>");
                    }
                    ++j;
                }
                if (!this.converterManager.isConvertable(method.getReturnType())) {
                    out.println("<br/><span class='warning'>(Warning: No Converter for " + method.getReturnType().getName() + ". See <a href='#missingConverter'>below</a>)</span>");
                }
                if ((warning = this.accessControl.getReasonToNotExecute(req, creator, scriptname, method)) != null) {
                    out.println("<br/><span class='warning'>(Warning: Role restructions in place: " + warning + ".)</span>");
                }
                out.println("</li>");
            }
            ++i;
        }
        out.println("");
        out.println("</ul>");
        out.println("<h2>Other Links</h2>");
        out.println("<ul>");
        out.println("<li>Back to <a href='" + req.getContextPath() + req.getServletPath() + "'>class index</a>.</li>");
        out.println("<li>Up to <a href='" + req.getContextPath() + "/'>top level of web app</a>.</li>");
        out.println("</ul>");
        var13_14 = this.scriptCache;
        synchronized (var13_14) {
            output = (String)this.scriptCache.get("help.html");
            if (output == null) {
                buffer = new StringBuffer();
                raw = this.getClass().getResourceAsStream("/uk/ltd/getahead/dwr/help.html");
                if (raw == null) {
                    DefaultProcessor.log.error(Messages.getString("DefaultProcessor.MissingHelp", "help.html"));
                    output = "<p>Failed to read help text from resource file. Check dwr.jar is built to include html files.</p>";
                } else {
                    in = new BufferedReader(new InputStreamReader(raw));
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                        buffer.append('\n');
                    }
                    output = buffer.toString();
                }
                this.scriptCache.put("help.html", output);
            }
            out.println(output);
        }
        out.println("</body></html>");
        out.flush();
    }

    protected void doInterface(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String scriptname = req.getPathInfo();
        scriptname = LocalUtil.replace(scriptname, PATH_INTERFACE, BLANK);
        scriptname = LocalUtil.replace(scriptname, EXTENSION_JS, BLANK);
        Creator creator = this.creatorManager.getCreator(scriptname);
        PrintWriter out = resp.getWriter();
        out.println();
        out.println("function " + scriptname + "() { }");
        out.println();
        Method[] methods = creator.getType().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
            if ((reason == null || this.allowImpossibleTests) && !this.jsutil.isReservedWord(methodName)) {
                if (i != 0) {
                    out.print('\n');
                }
                out.print(String.valueOf(scriptname) + '.' + methodName + " = function(");
                Class<?>[] paramTypes = method.getParameterTypes();
                int j = 0;
                while (j < paramTypes.length) {
                    if (!this.isAutoFilled(paramTypes[j])) {
                        out.print("p" + j + ", ");
                    }
                    ++j;
                }
                out.println("callback)");
                out.println('{');
                String path = String.valueOf(req.getContextPath()) + req.getServletPath();
                out.print("    DWREngine._execute('" + path + "', '" + scriptname + "', '" + methodName + "', ");
                int j2 = 0;
                while (j2 < paramTypes.length) {
                    if (this.isAutoFilled(paramTypes[j2])) {
                        out.print("false, ");
                    } else {
                        out.print("p" + j2 + ", ");
                    }
                    ++j2;
                }
                out.println("callback);");
                out.println('}');
            }
            ++i;
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFile(HttpServletResponse resp, String path, String mimeType) throws IOException {
        resp.setContentType(mimeType);
        String output = null;
        Map map = this.scriptCache;
        synchronized (map) {
            output = (String)this.scriptCache.get(path);
            if (output == null) {
                String line;
                StringBuffer buffer = new StringBuffer();
                InputStream raw = this.getClass().getResourceAsStream("/uk/ltd/getahead/dwr/" + path);
                BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                output = buffer.toString();
                if (mimeType.equals(MIME_JS) && this.scriptCompressed) {
                    output = this.jsutil.compress(output, this.compressionLevel);
                }
                this.scriptCache.put(path, output);
            }
        }
        PrintWriter out = resp.getWriter();
        out.println(output);
        out.flush();
    }

    /*
     * Unable to fully structure code
     */
    protected void doExec(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            block13: {
                block14: {
                    eq = new ExecuteQuery(this.creatorManager, this.converterManager, this.accessControl);
                    try {
                        calls = eq.execute(req);
                        break block13;
                    }
                    catch (Exception ex) {
                        if (!DefaultProcessor.log.isDebugEnabled()) break block14;
                        ex.printStackTrace();
                        DefaultProcessor.log.debug("Parse error: " + ex);
                        DefaultProcessor.log.debug("- User Agent: " + req.getHeader("User-Agent"));
                        DefaultProcessor.log.debug("- Remote IP:  " + req.getRemoteAddr());
                        DefaultProcessor.log.debug("- Request URL:" + req.getRequestURL());
                        DefaultProcessor.log.debug("- Query:      " + req.getQueryString());
                        DefaultProcessor.log.debug("- Method:     " + req.getMethod());
                        DefaultProcessor.log.debug("- Body: {");
                        lines = 0;
                        in = req.getReader();
                        ** while (in != null && lines < 100)
                    }
lbl-1000:
                    // 1 sources

                    {
                        line = in.readLine();
                        if (line == null) break;
                        DefaultProcessor.log.debug("-   " + line);
                        ++lines;
                        continue;
                    }
lbl24:
                    // 2 sources

                    DefaultProcessor.log.debug("- }" + req.getMethod());
                }
                resp.setContentType("text/html");
                out = resp.getWriter();
                out.println("//<script type='text/javascript'>");
                out.println("DWREngine._handleWarning('Your browser sent a request that could not be understood.\\nIf you understand how Javascript works in your browser, please help us fix the problem.\\nSee the mailing lists at http://www.getahead.ltd.uk/dwr/ for more information.');");
                out.println("//</script>");
                out.flush();
                return;
            }
            i = 0;
            while (i < calls.getCallCount()) {
                call = calls.getCall(i);
                if (call.getThrowable() != null) {
                    DefaultProcessor.log.warn("Erroring: id[" + call.getId() + "] message[" + call.getThrowable().toString() + ']');
                } else {
                    DefaultProcessor.log.debug("Returning: id[" + call.getId() + "] init[" + call.getReply().getInitCode() + "] assign[" + call.getReply().getAssignCode() + "] xhr[" + calls.isXhrMode() + ']');
                }
                ++i;
            }
            buffer = new StringBuffer();
            v0 = prefix = calls.isXhrMode() != false ? "" : "window.parent.";
            if (!calls.isXhrMode()) {
                buffer.append("<script type='text/javascript'>\n");
            }
            i = 0;
            while (i < calls.getCallCount()) {
                call = calls.getCall(i);
                if (call.getThrowable() != null) {
                    output = this.jsutil.escapeJavaScript(call.getThrowable().toString());
                    buffer.append(prefix);
                    buffer.append("DWREngine._handleError('");
                    buffer.append(call.getId());
                    buffer.append("', '");
                    buffer.append(output);
                    buffer.append("');\n");
                } else {
                    buffer.append(call.getReply().getInitCode());
                    buffer.append('\n');
                    buffer.append(prefix);
                    buffer.append("DWREngine._handleResponse('");
                    buffer.append(call.getId());
                    buffer.append("', ");
                    buffer.append(call.getReply().getAssignCode());
                    buffer.append(");\n");
                }
                ++i;
            }
            if (!calls.isXhrMode()) {
                buffer.append("</script>\n");
            }
            reply = buffer.toString();
            DefaultProcessor.log.debug(reply);
            resp.setContentType(calls.isXhrMode() != false ? "text/xml" : "text/html");
            out = resp.getWriter();
            out.print(reply);
            out.flush();
        }
        catch (Exception ex) {
            DefaultProcessor.log.error("Failure in doExec()", ex);
            resp.sendError(500);
        }
    }

    private boolean isAutoFilled(Class paramType) {
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("javax.servlet.http.HttpServletRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (paramType != clazz) {
            Class<?> clazz2 = class$12;
            if (clazz2 == null) {
                try {
                    clazz2 = class$12 = Class.forName("javax.servlet.http.HttpServletResponse");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (paramType != clazz2) {
                Class<?> clazz3 = class$13;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$13 = Class.forName("javax.servlet.ServletConfig");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (paramType != clazz3) {
                    Class<?> clazz4 = class$14;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$14 = Class.forName("javax.servlet.ServletContext");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (paramType != clazz4) {
                        Class<?> clazz5 = class$15;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$15 = Class.forName("javax.servlet.http.HttpSession");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (paramType != clazz5) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean isAllowImpossibleTests() {
        return this.allowImpossibleTests;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public CreatorManager getCreatorManager() {
        return this.creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public boolean isScriptCompressed() {
        return this.scriptCompressed;
    }

    public void setScriptCompressed(boolean scriptCompressed) {
        this.scriptCompressed = scriptCompressed;
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }
}

