/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

class ValueFormatter {
    protected static final int NO_SCALE = -1;
    protected static final double DEFAULT_BASE = 1000.0;
    private double base = 1000.0;
    private double[] scaleValues = new double[]{1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15};
    protected static String[] PREFIXES = new String[]{"E", "P", "T", "G", "M", "k", " ", "m", "\u00b5", "n", "p", "f"};
    private double value;
    private DecimalFormat decFormat;
    private int formattedStrLen;
    private double scaledValue;
    private int scaleIndex = -1;
    private int fixedIndex = -1;
    private String prefix;
    private boolean scale = false;

    ValueFormatter() {
    }

    ValueFormatter(double base, int scaleIndex) {
        this.setBase(base);
        this.fixedIndex = scaleIndex;
    }

    void setFormat(double value, int numDec, int strLen) {
        this.value = value;
        this.decFormat = this.getDecimalFormat(numDec);
        this.formattedStrLen = strLen;
    }

    void setScaling(boolean normalScale, boolean uniformScale) {
        if (!uniformScale) {
            this.scaleIndex = -1;
        }
        if (this.fixedIndex >= 0) {
            this.scale = true;
            this.scaleIndex = this.fixedIndex;
        } else {
            this.scale = normalScale || uniformScale;
        }
    }

    String getFormattedValue() {
        String valueStr = "" + this.value;
        if (!Double.isNaN(this.value)) {
            if (this.scale) {
                this.scaleValue(this.scaleIndex);
                valueStr = this.decFormat.format(this.scaledValue);
            } else {
                valueStr = this.decFormat.format(this.value);
            }
        }
        int diff = this.formattedStrLen - valueStr.length();
        StringBuffer preSpace = new StringBuffer("");
        for (int i = 0; i < diff; ++i) {
            preSpace.append(' ');
        }
        valueStr = preSpace.append(valueStr).toString();
        return valueStr;
    }

    String getScaledValue() {
        int tsv = this.scaleIndex;
        this.scaleValue(tsv);
        long intVal = new Double(this.scaledValue).longValue();
        this.scaleIndex = tsv;
        if ((double)intVal == this.scaledValue) {
            return "" + intVal;
        }
        return "" + this.scaledValue;
    }

    void setBase(double baseValue) {
        int i;
        if (baseValue == this.base) {
            return;
        }
        this.base = baseValue;
        double tmp = 1.0;
        for (i = 1; i < 7; ++i) {
            this.scaleValues[6 - i] = tmp *= baseValue;
        }
        tmp = 1.0;
        for (i = 7; i < this.scaleValues.length; ++i) {
            this.scaleValues[i] = 1.0 / (tmp *= baseValue);
        }
    }

    double getBase() {
        return this.base;
    }

    String getPrefix() {
        return this.prefix;
    }

    private void scaleValue(int scaleIndex) {
        double absValue = Math.abs(this.value);
        if (scaleIndex == -1) {
            this.prefix = " ";
            this.scaledValue = this.value;
            for (int i = 0; i < this.scaleValues.length; ++i) {
                if (!(absValue >= this.scaleValues[i]) || !(absValue < this.scaleValues[i] * this.base) || this.scaleValues[i] == 0.001) continue;
                this.prefix = PREFIXES[i];
                this.scaledValue = this.value / this.scaleValues[i];
                this.scaleIndex = i;
                return;
            }
        } else {
            this.prefix = PREFIXES[scaleIndex];
            this.scaledValue = this.value / this.scaleValues[scaleIndex];
            this.scaleIndex = scaleIndex;
        }
    }

    private DecimalFormat getDecimalFormat(int numDec) {
        StringBuffer formatStr = new StringBuffer("###0");
        for (int i = 0; i < numDec; ++i) {
            if (i == 0) {
                formatStr.append('.');
            }
            formatStr.append('0');
        }
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(formatStr.toString());
        return df;
    }
}

