/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.graph.ChartPanel;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.GifEncoder;
import org.jrobin.graph.Grapher;
import org.jrobin.graph.JpegImageWriteParam;
import org.jrobin.graph.RrdGraphDef;

public class RrdGraph
extends RrdOpener
implements Serializable {
    private Grapher grapher;
    private BufferedImage img;
    private boolean useImageSize = false;

    public RrdGraph() {
        super(false, true);
    }

    public RrdGraph(boolean usePool) {
        super(usePool, true);
    }

    public RrdGraph(RrdGraphDef graphDef) {
        this(graphDef, false);
    }

    public RrdGraph(RrdGraphDef graphDef, boolean usePool) {
        super(usePool, true);
        this.grapher = new Grapher(graphDef, this);
    }

    public void specifyImageSize(boolean specImgSize) {
        this.useImageSize = specImgSize;
    }

    public void setGraphDef(RrdGraphDef graphDef) {
        this.img = null;
        this.grapher = new Grapher(graphDef, this);
    }

    public void saveAsPNG(String path) throws RrdException, IOException {
        this.saveAsPNG(path, 0, 0);
    }

    public void saveAsPNG(String path, int width, int height) throws RrdException, IOException {
        File imgFile = new File(path);
        if (this.shouldGenerate(imgFile)) {
            ImageIO.write((RenderedImage)this.getBufferedImage(width, height, 1), "png", imgFile);
        }
    }

    public void saveAsGIF(String path) throws RrdException, IOException {
        this.saveAsGIF(path, 0, 0);
    }

    public void saveAsGIF(String path, int width, int height) throws RrdException, IOException {
        File imgFile = new File(path);
        if (this.shouldGenerate(imgFile)) {
            GifEncoder gifEncoder = new GifEncoder(this.getBufferedImage(width, height, 13));
            FileOutputStream stream = new FileOutputStream(path, false);
            gifEncoder.encode(stream);
            stream.close();
        }
    }

    public void saveAsJPEG(String path, float quality) throws RrdException, IOException {
        this.saveAsJPEG(path, 0, 0, quality);
    }

    public void saveAsJPEG(String path, int width, int height, float quality) throws RrdException, IOException {
        File imgFile = new File(path);
        if (!this.shouldGenerate(imgFile)) {
            return;
        }
        BufferedImage rndImage = this.getBufferedImage(width, height, 1);
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(new File(path));
        writer.setOutput(ios);
        JpegImageWriteParam iwparam = new JpegImageWriteParam();
        iwparam.setCompressionMode(2);
        ((ImageWriteParam)iwparam).setCompressionQuality(quality);
        writer.write(null, new IIOImage(rndImage, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public byte[] getPNGBytes() throws IOException, RrdException {
        return this.getPNGBytes(0, 0);
    }

    public byte[] getPNGBytes(int width, int height) throws IOException, RrdException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.getBufferedImage(width, height, 1), "png", outputStream);
        return outputStream.toByteArray();
    }

    public byte[] getJPEGBytes(float quality) throws IOException, RrdException {
        return this.getJPEGBytes(0, 0, quality);
    }

    public byte[] getJPEGBytes(int width, int height, float quality) throws IOException, RrdException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage rndImage = this.getBufferedImage(width, height, 1);
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);
        writer.setOutput(ios);
        JpegImageWriteParam iwparam = new JpegImageWriteParam();
        iwparam.setCompressionMode(2);
        ((ImageWriteParam)iwparam).setCompressionQuality(quality);
        writer.write(null, new IIOImage(rndImage, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
        return outputStream.toByteArray();
    }

    public byte[] getGIFBytes() throws RrdException, IOException {
        return this.getGIFBytes(0, 0);
    }

    public byte[] getGIFBytes(int width, int height) throws RrdException, IOException {
        BufferedImage image = this.getBufferedImage(width, height, 13);
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        GifEncoder gifEncoder = new GifEncoder(image);
        gifEncoder.encode(bStream);
        return bStream.toByteArray();
    }

    public BufferedImage getBufferedImage(int width, int height) throws IOException, RrdException {
        return this.getBufferedImage(width, height, 1);
    }

    public ChartPanel getChartPanel() throws RrdException, IOException {
        ChartPanel p = new ChartPanel();
        p.setChart(this.getBufferedImage(0, 0, 1));
        return p;
    }

    public void renderImage(Graphics2D graphics, int width, int height) throws RrdException, IOException {
        if (this.useImageSize) {
            this.grapher.renderImage(width, height, graphics, true);
        } else {
            this.grapher.renderImage(width, height, graphics, false);
        }
    }

    public ExportData getExportData() throws RrdException {
        return this.grapher.createExportData();
    }

    public ExportData fetchExportData() throws RrdException, IOException {
        return this.grapher.fetch(400);
    }

    public ExportData fetchExportData(int maxRows) throws RrdException, IOException {
        return this.grapher.fetch(maxRows);
    }

    private boolean shouldGenerate(File imgFile) throws RrdException, IOException {
        if (!imgFile.exists()) {
            return true;
        }
        return this.grapher.shouldGenerate(imgFile.lastModified());
    }

    private BufferedImage getBufferedImage(int width, int height, int colorType) throws RrdException, IOException {
        this.img = this.useImageSize ? this.grapher.createImageGlobal(width, height, colorType) : this.grapher.createImage(width, height, colorType);
        return this.img;
    }
}

