/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdExportDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdExportDefTemplate
extends XmlTemplate {
    private RrdExportDef def;

    public RrdExportDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdExportDefTemplate(File xmlFile) throws IOException, RrdException {
        super(xmlFile);
    }

    public RrdExportDefTemplate(String xmlString) throws IOException, RrdException {
        super(xmlString);
    }

    public RrdExportDef getRrdExportDef() throws RrdException {
        if (!this.root.getTagName().equals("rrd_export_def")) {
            throw new RrdException("XML definition must start with <rrd_export_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"span", "options", "datasources", "exports"});
        this.def = new RrdExportDef();
        Node[] childs = RrdExportDefTemplate.getChildNodes(this.root);
        for (int i = 0; i < childs.length; ++i) {
            String nodeName = childs[i].getNodeName();
            if (nodeName.equals("span")) {
                this.resolveSpan(childs[i]);
                continue;
            }
            if (nodeName.equals("options")) {
                this.resolveOptions(childs[i]);
                continue;
            }
            if (nodeName.equals("datasources")) {
                this.resolveDatasources(childs[i]);
                continue;
            }
            if (!nodeName.equals("exports")) continue;
            this.resolveExports(childs[i]);
        }
        return this.def;
    }

    private void resolveExports(Node datasourceNode) throws RrdException {
        this.validateTagsOnlyOnce(datasourceNode, new String[]{"export*"});
        Node[] nodes = RrdExportDefTemplate.getChildNodes(datasourceNode, "export");
        for (int i = 0; i < nodes.length; ++i) {
            this.validateTagsOnlyOnce(nodes[i], new String[]{"datasource", "legend"});
            String ds = this.getChildValue(nodes[i], "datasource");
            String legend = this.getChildValue(nodes[i], "legend");
            this.def.export(ds, legend);
        }
    }

    private void resolveDatasources(Node datasourceNode) throws RrdException {
        int i;
        this.validateTagsOnlyOnce(datasourceNode, new String[]{"def*", "export_data*"});
        Node[] nodes = RrdExportDefTemplate.getChildNodes(datasourceNode, "def");
        for (i = 0; i < nodes.length; ++i) {
            String name;
            if (this.hasChildNode(nodes[i], "rrd")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "rrd", "source", "cf", "backend"});
                name = this.getChildValue(nodes[i], "name");
                String rrd = this.getChildValue(nodes[i], "rrd");
                String dsName = this.getChildValue(nodes[i], "source");
                String consolFun = this.getChildValue(nodes[i], "cf");
                if (Util.Xml.hasChildNode(nodes[i], "backend")) {
                    String backend = this.getChildValue(nodes[i], "backend");
                    this.def.datasource(name, rrd, dsName, consolFun, backend);
                    continue;
                }
                this.def.datasource(name, rrd, dsName, consolFun);
                continue;
            }
            if (this.hasChildNode(nodes[i], "rpn")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "rpn"});
                name = this.getChildValue(nodes[i], "name");
                String rpn = this.getChildValue(nodes[i], "rpn");
                this.def.datasource(name, rpn);
                continue;
            }
            if (this.hasChildNode(nodes[i], "cf") || this.hasChildNode(nodes[i], "datasource")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "datasource", "cf"});
                name = this.getChildValue(nodes[i], "name");
                String ds = this.getChildValue(nodes[i], "datasource");
                String cf = this.getChildValue(nodes[i], "cf");
                this.def.datasource(name, ds, cf);
                continue;
            }
            throw new RrdException("Unrecognized <def> format");
        }
        nodes = RrdExportDefTemplate.getChildNodes(datasourceNode, "export_data");
        for (i = 0; i < nodes.length; ++i) {
            this.validateTagsOnlyOnce(nodes[i], new String[]{"file", "ds_name_prefix", "use_legend_names"});
            String file = this.getChildValue(nodes[i], "file");
            String prefix = "d";
            boolean use_legends = false;
            if (Util.Xml.hasChildNode(nodes[i], "ds_name_prefix")) {
                prefix = this.getChildValue(nodes[i], "ds_name_prefix");
            }
            if (Util.Xml.hasChildNode(nodes[i], "use_legend_names")) {
                use_legends = this.getChildValueAsBoolean(nodes[i], "use_legend_names");
            }
            try {
                if (!prefix.equals("d")) {
                    this.def.addExportData(new ExportData(new File(file), prefix));
                    continue;
                }
                this.def.addExportData(new ExportData(new File(file), use_legends));
                continue;
            }
            catch (IOException ioe) {
                throw new RrdException(ioe);
            }
        }
    }

    private void resolveOptions(Node rootOptionNode) throws RrdException {
        this.validateTagsOnlyOnce(rootOptionNode, new String[]{"resolution", "strict_export"});
        Node[] optionNodes = RrdExportDefTemplate.getChildNodes(rootOptionNode);
        for (int i = 0; i < optionNodes.length; ++i) {
            String option = optionNodes[i].getNodeName();
            Node optionNode = optionNodes[i];
            if (option.equals("strict_export")) {
                this.def.setStrictExport(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (!option.equals("resolution")) continue;
            this.def.setResolution(this.getValueAsInt(optionNode));
        }
    }

    private void resolveSpan(Node spanNode) throws RrdException {
        this.validateTagsOnlyOnce(spanNode, new String[]{"start", "end"});
        String startStr = this.getChildValue(spanNode, "start");
        String endStr = this.getChildValue(spanNode, "end");
        GregorianCalendar gc1 = Util.getGregorianCalendar(startStr);
        GregorianCalendar gc2 = Util.getGregorianCalendar(endStr);
        this.def.setTimePeriod(gc1, gc2);
    }
}

