/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class RrdToolkit {
    private static RrdToolkit ourInstance;

    public static synchronized RrdToolkit getInstance() {
        if (ourInstance == null) {
            ourInstance = new RrdToolkit();
        }
        return ourInstance;
    }

    private RrdToolkit() {
    }

    public void addDatasource(String sourcePath, String destPath, DsDef newDatasource) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        RrdDef rrdDef = rrdSource.getRrdDef();
        rrdDef.setPath(destPath);
        rrdDef.addDatasource(newDatasource);
        RrdDb rrdDest = new RrdDb(rrdDef);
        rrdSource.copyStateTo(rrdDest);
        rrdSource.close();
        rrdDest.close();
    }

    public void addDatasource(String sourcePath, DsDef newDatasource, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        this.addDatasource(sourcePath, destPath, newDatasource);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public void removeDatasource(String sourcePath, String destPath, String dsName) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        RrdDef rrdDef = rrdSource.getRrdDef();
        rrdDef.setPath(destPath);
        rrdDef.removeDatasource(dsName);
        RrdDb rrdDest = new RrdDb(rrdDef);
        rrdSource.copyStateTo(rrdDest);
        rrdSource.close();
        rrdDest.close();
    }

    public void removeDatasource(String sourcePath, String dsName, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        this.removeDatasource(sourcePath, destPath, dsName);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public void addArchive(String sourcePath, String destPath, ArcDef newArchive) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        RrdDef rrdDef = rrdSource.getRrdDef();
        rrdDef.setPath(destPath);
        rrdDef.addArchive(newArchive);
        RrdDb rrdDest = new RrdDb(rrdDef);
        rrdSource.copyStateTo(rrdDest);
        rrdSource.close();
        rrdDest.close();
    }

    public void addArchive(String sourcePath, ArcDef newArchive, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        this.addArchive(sourcePath, destPath, newArchive);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public void removeArchive(String sourcePath, String destPath, String consolFun, int steps) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        RrdDef rrdDef = rrdSource.getRrdDef();
        rrdDef.setPath(destPath);
        rrdDef.removeArchive(consolFun, steps);
        RrdDb rrdDest = new RrdDb(rrdDef);
        rrdSource.copyStateTo(rrdDest);
        rrdSource.close();
        rrdDest.close();
    }

    public void removeArchive(String sourcePath, String consolFun, int steps, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        this.removeArchive(sourcePath, destPath, consolFun, steps);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void copyFile(String sourcePath, String destPath, boolean saveBackup) throws IOException {
        File source = new File(sourcePath);
        File dest = new File(destPath);
        if (saveBackup) {
            String backupPath = RrdToolkit.getBackupPath(destPath);
            File backup = new File(backupPath);
            RrdToolkit.deleteFile(backup);
            if (!dest.renameTo(backup)) {
                throw new IOException("Could not create backup file " + backupPath);
            }
        }
        RrdToolkit.deleteFile(dest);
        if (!source.renameTo(dest)) {
            throw new IOException("Could not create file " + destPath + " from " + sourcePath);
        }
    }

    private static String getBackupPath(String destPath) {
        String backupPath = destPath;
        while (new File(backupPath = backupPath + ".bak").exists()) {
        }
        return backupPath;
    }

    public void setDsHeartbeat(String sourcePath, String datasourceName, long newHeartbeat) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        Datasource ds = rrd.getDatasource(datasourceName);
        ds.setHeartbeat(newHeartbeat);
        rrd.close();
    }

    public void setDsMinValue(String sourcePath, String datasourceName, double newMinValue, boolean filterArchivedValues) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        Datasource ds = rrd.getDatasource(datasourceName);
        ds.setMinValue(newMinValue, filterArchivedValues);
        rrd.close();
    }

    public void setDsMaxValue(String sourcePath, String datasourceName, double newMaxValue, boolean filterArchivedValues) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        Datasource ds = rrd.getDatasource(datasourceName);
        ds.setMaxValue(newMaxValue, filterArchivedValues);
        rrd.close();
    }

    public void setDsMinMaxValue(String sourcePath, String datasourceName, double newMinValue, double newMaxValue, boolean filterArchivedValues) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        Datasource ds = rrd.getDatasource(datasourceName);
        ds.setMinMaxValue(newMinValue, newMaxValue, filterArchivedValues);
        rrd.close();
    }

    public void setArcXff(String sourcePath, String consolFun, int steps, double newXff) throws RrdException, IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        Archive arc = rrd.getArchive(consolFun, steps);
        arc.setXff(newXff);
        rrd.close();
    }

    public void resizeArchive(String sourcePath, String destPath, String consolFun, int numSteps, int newRows) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        if (newRows < 2) {
            throw new RrdException("New arcihve size must be at least 2");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        RrdDef rrdDef = rrdSource.getRrdDef();
        ArcDef arcDef = rrdDef.findArchive(consolFun, numSteps);
        if (arcDef.getRows() != newRows) {
            arcDef.setRows(newRows);
            rrdDef.setPath(destPath);
            RrdDb rrdDest = new RrdDb(rrdDef);
            rrdSource.copyStateTo(rrdDest);
            rrdDest.close();
        }
        rrdSource.close();
    }

    public void resizeArchive(String sourcePath, String consolFun, int numSteps, int newRows, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        this.resizeArchive(sourcePath, destPath, consolFun, numSteps, newRows);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }
}

