/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient4FactoryBean
implements FactoryBean<HttpClient>,
InitializingBean {
    private HttpClient client;
    private int maxConnections = 1000;
    private int maxConnectionsPerRoute = 100;
    private int socketTimeoutMs = 10000;
    private int connectionTimeoutMs = 10000;

    public void afterPropertiesSet() throws Exception {
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager((HttpParams)this.createConnectionManagerParams(), this.createSchemeRegistry());
        HttpParams params = this.createClientParams();
        this.client = new DefaultHttpClient((ClientConnectionManager)connManager, params);
    }

    public HttpClient getObject() throws Exception {
        return this.client;
    }

    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private BasicHttpParams createConnectionManagerParams() {
        BasicHttpParams connManagerParams = new BasicHttpParams();
        connManagerParams.setParameter("http.conn-manager.max-total", (Object)new Integer(this.maxConnections));
        connManagerParams.setParameter("http.conn-manager.max-per-route", (Object)new ConnPerRouteBean(this.maxConnectionsPerRoute));
        return connManagerParams;
    }

    private SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        Scheme httpScheme = new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80);
        schemeRegistry.register(httpScheme);
        return schemeRegistry;
    }

    private HttpParams createClientParams() {
        BasicHttpParams clientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)clientParams, (int)this.connectionTimeoutMs);
        HttpConnectionParams.setSoTimeout((HttpParams)clientParams, (int)this.socketTimeoutMs);
        return clientParams;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }
}

