/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.cart;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Phraser
implements UtteranceProcessor {
    private static final Logger LOGGER = Logger.getLogger(UtteranceProcessor.class.getName());
    protected final CART cart;

    public Phraser(CART cart) {
        this.cart = cart;
    }

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation relation = utterance.createRelation("Phrase");
        Item p = null;
        for (Item w = utterance.getRelation("Word").getHead(); w != null; w = w.getNext()) {
            if (p == null) {
                p = relation.appendItem();
                p.getFeatures().setString("name", "BB");
            }
            p.addDaughter(w);
            String results = (String)this.cart.interpret(w);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("word: " + w + ", results: " + results);
            }
            if (!results.equals("BB")) continue;
            p = null;
        }
    }

    public String toString() {
        return "CARTPhraser";
    }
}

