/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.AimSessionListener;
import net.kano.joustsim.oscar.BuddyInfoTracker;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationException;
import net.kano.joustsim.oscar.oscar.service.icbm.DirectMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.ImMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageQueuedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.SendFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingNotificationConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Attachment;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.BuddyTypingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimController;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DoneReceivingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.OutgoingDirectimConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivedAttachmentEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivedMessageEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.SentCompletePacketEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionEventListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import org.jetbrains.annotations.Nullable;

public class DirectimConversation
extends Conversation
implements TypingNotificationConversation {
    private static final Logger LOGGER = Logger.getLogger(DirectimConversation.class.getName());
    private final AimConnection conn;
    private DirectimConnection directim = null;
    @Nullable
    private RvConnectionEvent closingState = null;
    private BuddyInfoTracker oldTracker = null;
    private final BuddyInfoTrackerListener trackListener = new BuddyInfoTrackerListener(){};
    private LinkedList<Message> queue = new LinkedList();
    private TypingState typingState = TypingState.NO_TEXT;

    public DirectimConversation(AimConnection conn, DirectimConnection directim) {
        super(directim.getBuddyScreenname());
        this.conn = conn;
        this.directim = directim;
        this.registerConnection(directim);
    }

    public DirectimConversation(AimConnection conn, Screenname buddy) {
        super(buddy);
        this.conn = conn;
    }

    protected void opened() {
        this.conn.getAimSession().addSessionListener(new AimSessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleOpenedConnection(AimSession aimSession, AimConnection conn) {
                DirectimConversation directimConversation = DirectimConversation.this;
                synchronized (directimConversation) {
                    DirectimConversation.this.clearOldTracker();
                    DirectimConversation.this.oldTracker = conn.getBuddyInfoTracker();
                    DirectimConversation.this.oldTracker.addTracker(DirectimConversation.this.getBuddy(), DirectimConversation.this.trackListener);
                }
            }
        });
    }

    private synchronized void clearOldTracker() {
        if (this.oldTracker != null) {
            this.oldTracker.removeTracker(this.getBuddy(), this.trackListener);
            this.oldTracker = null;
        }
    }

    public synchronized DirectimConnection getDirectimConnection() {
        return this.directim;
    }

    @Nullable
    public synchronized RvConnectionEvent getClosingEvent() {
        return this.closingState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        OutgoingDirectimConnectionImpl directim;
        DirectimConversation directimConversation = this;
        synchronized (directimConversation) {
            if (this.directim != null) {
                if (this.directim instanceof IncomingRvConnection) {
                    IncomingRvConnection in = (IncomingRvConnection)((Object)this.directim);
                    try {
                        in.accept();
                    }
                    catch (IllegalStateException e) {
                        LOGGER.warning("Couldn't accept DIM connection: " + e);
                    }
                }
                return false;
            }
            LOGGER.fine("Opening dim connection to " + this.getBuddy());
            directim = this.conn.getIcbmService().getRvConnectionManager().openDirectimConnection(this.getBuddy());
            this.registerConnection(directim);
            this.directim = directim;
        }
        directim.sendRequest();
        return false;
    }

    private synchronized void registerConnection(DirectimConnection directim) {
        directim.addEventListener(new DirectimEventListener());
        this.updateState(directim.getState(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(RvConnectionState state, @Nullable RvConnectionEvent event) {
        if (state == RvConnectionState.CONNECTED) {
            DirectimController controller = this.getDirectimController();
            assert (controller != null);
            DirectimConversation directimConversation = this;
            synchronized (directimConversation) {
                for (Message msg : this.queue) {
                    controller.sendMessage(msg);
                }
                this.queue.clear();
            }
            controller.setTypingState(this.typingState);
            super.open();
        } else if (state == RvConnectionState.FAILED || state == RvConnectionState.FINISHED) {
            DirectimConversation directimConversation = this;
            synchronized (directimConversation) {
                if (this.closingState == null) {
                    this.closingState = event;
                }
            }
            super.close();
        }
    }

    private DirectimController getDirectimController() {
        return this.getDirectimConnection().getDirectimController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed() {
        ArrayList<Message> failed;
        DirectimConversation directimConversation = this;
        synchronized (directimConversation) {
            if (this.directim != null) {
                this.directim.close();
                this.directim = null;
            }
            this.clearOldTracker();
            failed = new ArrayList<Message>(this.queue);
            this.queue.clear();
        }
        for (Message message : failed) {
            this.fireOutgoingEvent(new SendFailedEvent(this.conn.getScreenname(), this.getBuddy(), message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg) throws ConversationException {
        DirectimController controller;
        this.fireOutgoingEvent(new MessageQueuedEvent(msg, this.conn.getScreenname(), this.getBuddy()));
        DirectimConversation directimConversation = this;
        synchronized (directimConversation) {
            DirectimController directimController = controller = this.directim == null ? null : this.directim.getDirectimController();
            if (controller == null) {
                LOGGER.info("Queueing message until DIM opens: " + msg);
                this.queue.add(msg);
                return;
            }
        }
        LOGGER.fine("Sending message over dim: " + msg);
        controller.sendMessage(msg);
        this.fireOutgoingEvent(ImMessageInfo.getInstance(this.conn.getScreenname(), this.getBuddy(), msg, new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypingState(TypingState typingState) {
        DirectimConnection directim;
        DirectimConversation directimConversation = this;
        synchronized (directimConversation) {
            this.typingState = typingState;
            if (!this.isOpen()) {
                return;
            }
            directim = this.directim;
        }
        DirectimController controller = directim.getDirectimController();
        if (controller == null) {
            return;
        }
        controller.setTypingState(typingState);
        this.fireOutgoingEvent(new TypingInfo(this.conn.getScreenname(), this.getBuddy(), new Date(), typingState));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectimEventListener
    implements RvConnectionEventListener {
        private ReceivedMessageEvent lastMsg = null;
        private List<ReceivedAttachmentEvent> attachments = null;

        private DirectimEventListener() {
        }

        @Override
        public void handleEventWithStateChange(RvConnection transfer, RvConnectionState state, RvConnectionEvent event) {
            LOGGER.fine("Directim for conversation changed to state: " + state);
            DirectimConversation.this.updateState(state, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(RvConnection transfer, RvConnectionEvent event) {
            if (event instanceof BuddyTypingEvent) {
                BuddyTypingEvent tevent = (BuddyTypingEvent)event;
                LOGGER.finer("Got incoming typing state in conversation: " + tevent);
                DirectimConversation.this.fireIncomingEvent(new TypingInfo(DirectimConversation.this.getBuddy(), DirectimConversation.this.getBuddy(), new Date(), tevent.getState()));
            } else if (event instanceof ReceivedMessageEvent) {
                ReceivedMessageEvent revent = (ReceivedMessageEvent)event;
                this.setLastMessage(revent);
                LOGGER.finer("Got incoming DIM message in conversation: " + revent);
            } else {
                if (event instanceof ReceivedAttachmentEvent) {
                    ReceivedAttachmentEvent revent = (ReceivedAttachmentEvent)event;
                    LOGGER.finer("Got attachment " + revent.getId() + " in conversation");
                    DirectimEventListener directimEventListener = this;
                    synchronized (directimEventListener) {
                        assert (this.attachments != null) : event;
                        this.attachments.add(revent);
                    }
                }
                if (event instanceof DoneReceivingEvent) {
                    List<ReceivedAttachmentEvent> attachments;
                    ReceivedMessageEvent lastMsg;
                    DirectimEventListener directimEventListener = this;
                    synchronized (directimEventListener) {
                        lastMsg = this.lastMsg;
                        attachments = this.attachments;
                        this.lastMsg = null;
                        this.attachments = null;
                    }
                    Date date = new Date();
                    DirectMessage msg = new DirectMessage(lastMsg.getMessage(), lastMsg.isAutoResponse(), this.buildAttachmentList(attachments));
                    DirectimConversation.this.fireIncomingEvent(ImMessageInfo.getInstance(DirectimConversation.this.getBuddy(), DirectimConversation.this.conn.getScreenname(), msg, date));
                } else if (event instanceof SentCompletePacketEvent) {
                    SentCompletePacketEvent scpe = (SentCompletePacketEvent)event;
                    DirectimConversation.this.fireMessageSentEvent(scpe.getMessage(), DirectimConversation.this.conn.getScreenname());
                }
            }
        }

        private synchronized void setLastMessage(ReceivedMessageEvent revent) {
            assert (this.lastMsg == null);
            assert (this.attachments == null);
            this.lastMsg = revent;
            this.attachments = new ArrayList<ReceivedAttachmentEvent>();
        }

        private Set<Attachment> buildAttachmentList(List<ReceivedAttachmentEvent> attachments) {
            HashSet<Attachment> map = new HashSet<Attachment>();
            for (ReceivedAttachmentEvent ev : attachments) {
                map.add(ev.getAttachment());
            }
            return map;
        }
    }
}

