/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatMessage;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomMessageFactory;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomUser;
import net.kano.joustsim.oscar.oscar.service.chatrooms.EncodingException;
import net.kano.joustsim.trust.KeyPair;
import net.kano.joustsim.trust.TrustPreferences;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class EncryptedChatRoomMessageFactory
implements ChatRoomMessageFactory {
    private AimConnection aimConnection;
    private ChatRoomService roomService;
    private SecretKey key;
    private SecureRandom random = new SecureRandom();

    public EncryptedChatRoomMessageFactory(AimConnection aimConnection, ChatRoomService roomService, SecretKey key) {
        this.aimConnection = aimConnection;
        this.roomService = roomService;
        this.key = key;
    }

    public ChatMessage createMessage(ChatRoomService service, ChatRoomUser user, ChatMsg message) {
        ByteBlock data = message.getMessageData();
        return null;
    }

    public ChatMsg encodeMessage(String message) throws EncodingException {
        byte[] data;
        try {
            data = this.getEncodedMessageData(message);
        }
        catch (IOException e) {
            throw new EncodingException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException(e);
        }
        catch (NoSuchProviderException e) {
            throw new EncodingException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncodingException(e);
        }
        catch (InvalidKeyException e) {
            throw new EncodingException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncodingException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncodingException(e);
        }
        catch (BadPaddingException e) {
            throw new EncodingException(e);
        }
        catch (CMSException e) {
            throw new EncodingException(e);
        }
        return new ChatMsg("application/pkcs7-mime", "binary", "UTF-8", ByteBlock.wrap((byte[])data), Locale.getDefault());
    }

    private byte[] getEncodedMessageData(String message) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CMSException {
        byte[] dataToEncrypt = this.getCmsSignedBlock(message);
        byte[] iv = new byte[16];
        this.random.nextBytes(iv);
        Cipher c = Cipher.getInstance("2.16.840.1.101.3.4.1.42", "BC");
        c.init(1, (Key)this.key, new IvParameterSpec(iv));
        byte[] encrypted = c.doFinal(dataToEncrypt);
        EncryptedContentInfo eci = new EncryptedContentInfo(new DERObjectIdentifier("1.2.840.113549.1.7.1"), new AlgorithmIdentifier(new DERObjectIdentifier("2.16.840.1.101.3.4.1.42"), (DEREncodable)new DEROctetString(iv)), (ASN1OctetString)new BERConstructedOctetString(encrypted));
        EncryptedData ed = new EncryptedData(eci.getContentType(), eci.getContentEncryptionAlgorithm(), (DEREncodable)eci.getEncryptedContent());
        BERTaggedObject bert = new BERTaggedObject(0, (DEREncodable)ed.getDERObject());
        DERObjectIdentifier rootid = new DERObjectIdentifier("1.2.840.113549.1.7.6");
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((DEREncodable)rootid);
        vec.add((DEREncodable)bert);
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        ASN1OutputStream out = new ASN1OutputStream((OutputStream)fout);
        out.writeObject((Object)new BERSequence((DEREncodableVector)vec));
        out.close();
        return fout.toByteArray();
    }

    private byte[] getCmsSignedBlock(String msg) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, CMSException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bout, "US-ASCII");
        osw.write("Content-Transfer-Encoding: binary\r\nContent-Type: text/x-aolrtf; charset=us-ascii\r\nContent-Language: en\r\n\r\n");
        osw.flush();
        bout.write(msg.getBytes("UTF-8"));
        byte[] dataToSign = bout.toByteArray();
        byte[] signedData = this.signData(dataToSign);
        bout = new ByteArrayOutputStream();
        osw = new OutputStreamWriter((OutputStream)bout, "US-ASCII");
        osw.write("Content-Transfer-Encoding: binary\r\nContent-Type: application/pkcs7-mime; charset=us-ascii\r\nContent-Language: en\r\n\r\n");
        osw.flush();
        bout.write(signedData);
        return bout.toByteArray();
    }

    private byte[] signData(byte[] dataToSign) throws NoSuchProviderException, NoSuchAlgorithmException, CMSException, IOException {
        CMSSignedDataGenerator sgen = new CMSSignedDataGenerator();
        TrustPreferences localPrefs = this.aimConnection.getLocalPrefs();
        KeyPair signingKeys = localPrefs.getPrivateKeysPreferences().getKeysInfo().getSigningKeys();
        sgen.addSigner((PrivateKey)signingKeys.getPrivateKey(), signingKeys.getPublicCertificate(), "1.2.840.113549.2.5");
        CMSSignedData csd = sgen.generate((CMSProcessable)new CMSProcessableByteArray(dataToSign), true, "BC");
        return csd.getEncoded();
    }
}

