/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.ReplicaFragmentMigrationState;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.operation.BaseMigrationSourceOperation;
import com.hazelcast.internal.partition.operation.MigrationOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.FragmentedMigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.SimpleExecutionCallback;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MigrationRequestOperation
extends BaseMigrationSourceOperation {
    private boolean fragmentedMigrationEnabled;
    private transient ServiceNamespacesContext namespacesContext;

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo, int partitionStateVersion, boolean fragmentedMigrationEnabled) {
        super(migrationInfo, partitionStateVersion);
        this.fragmentedMigrationEnabled = fragmentedMigrationEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.verifyMasterOnMigrationSource();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address source = this.migrationInfo.getSource();
        Address destination = this.migrationInfo.getDestination();
        this.verifyExistingTarget(nodeEngine, destination);
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.setFailed();
            return;
        }
        InternalPartition partition = this.getPartition();
        this.verifySource(nodeEngine.getThisAddress(), partition);
        this.setActiveMigration();
        if (!this.migrationInfo.startProcessing()) {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.setFailed();
            return;
        }
        try {
            this.executeBeforeMigrations();
            this.namespacesContext = new ServiceNamespacesContext(nodeEngine, this.getPartitionReplicationEvent());
            ReplicaFragmentMigrationState migrationState = this.fragmentedMigrationEnabled ? this.createNextReplicaFragmentMigrationState() : this.createAllReplicaFragmentsMigrationState();
            this.invokeMigrationOperation(destination, migrationState, true);
            this.returnResponse = false;
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.setFailed();
        }
        finally {
            this.migrationInfo.doneProcessing();
        }
    }

    @Override
    void onMigrationStart() {
        ((OperationServiceImpl)this.getNodeEngine().getOperationService()).onStartAsyncOperation(this);
        super.onMigrationStart();
    }

    @Override
    void onMigrationComplete(boolean result) {
        try {
            super.onMigrationComplete(result);
        }
        finally {
            ((OperationServiceImpl)this.getNodeEngine().getOperationService()).onCompletionAsyncOperation(this);
        }
    }

    private void invokeMigrationOperation(Address destination, ReplicaFragmentMigrationState migrationState, boolean firstFragment) throws IOException {
        boolean lastFragment = !this.fragmentedMigrationEnabled || !this.namespacesContext.hasNext();
        MigrationOperation operation = new MigrationOperation(this.migrationInfo, this.partitionStateVersion, migrationState, firstFragment, lastFragment);
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            Set namespaces = migrationState != null ? migrationState.getNamespaceVersionMap().keySet() : Collections.emptySet();
            logger.finest("Invoking MigrationOperation for namespaces " + namespaces + " and " + this.migrationInfo + ", lastFragment: " + lastFragment);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination).setExecutionCallback(new MigrationCallback()).setResultDeserialized(true).setCallTimeout(partitionService.getPartitionMigrationTimeout()).setTryCount(12).setTryPauseMillis(10000L).setReplicaIndex(this.getReplicaIndex()).invoke();
    }

    private void trySendNewFragment() {
        try {
            assert (this.fragmentedMigrationEnabled) : "Fragmented migration should be enabled!";
            this.verifyMasterOnMigrationSource();
            NodeEngine nodeEngine = this.getNodeEngine();
            Address destination = this.migrationInfo.getDestination();
            this.verifyExistingTarget(nodeEngine, destination);
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            MigrationManager migrationManager = partitionService.getMigrationManager();
            MigrationInfo currentActiveMigration = migrationManager.setActiveMigration(this.migrationInfo);
            if (!this.migrationInfo.equals(currentActiveMigration)) {
                throw new IllegalStateException("Current active migration " + currentActiveMigration + " is different than expected: " + this.migrationInfo);
            }
            ReplicaFragmentMigrationState migrationState = this.createNextReplicaFragmentMigrationState();
            if (migrationState != null) {
                this.invokeMigrationOperation(destination, migrationState, false);
            } else {
                this.getLogger().finest("All migration fragments done for " + this.migrationInfo);
                this.completeMigration(true);
            }
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.completeMigration(false);
        }
    }

    private ReplicaFragmentMigrationState createNextReplicaFragmentMigrationState() {
        assert (this.fragmentedMigrationEnabled) : "Fragmented migration should be enabled!";
        if (!this.namespacesContext.hasNext()) {
            return null;
        }
        ServiceNamespace namespace = this.namespacesContext.next();
        if (namespace.equals(NonFragmentedServiceNamespace.INSTANCE)) {
            return this.createNonFragmentedReplicaFragmentMigrationState();
        }
        return this.createReplicaFragmentMigrationStateFor(namespace);
    }

    private ReplicaFragmentMigrationState createNonFragmentedReplicaFragmentMigrationState() {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<Operation> operations = this.createNonFragmentedReplicationOperations(event);
        Set<ServiceNamespace> namespaces = Collections.singleton(NonFragmentedServiceNamespace.INSTANCE);
        return this.createReplicaFragmentMigrationState(namespaces, operations);
    }

    private ReplicaFragmentMigrationState createReplicaFragmentMigrationStateFor(ServiceNamespace ns) {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<String> serviceNames = this.namespacesContext.getServiceNames(ns);
        Collection<Operation> operations = this.createFragmentReplicationOperations(event, ns, serviceNames);
        return this.createReplicaFragmentMigrationState(Collections.singleton(ns), operations);
    }

    private ReplicaFragmentMigrationState createAllReplicaFragmentsMigrationState() {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<Operation> operations = this.createAllReplicationOperations(event);
        return this.createReplicaFragmentMigrationState(this.namespacesContext.allNamespaces, operations);
    }

    private ReplicaFragmentMigrationState createReplicaFragmentMigrationState(Collection<ServiceNamespace> namespaces, Collection<Operation> operations) {
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        HashMap<ServiceNamespace, long[]> versions = new HashMap<ServiceNamespace, long[]>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            long[] v = versionManager.getPartitionReplicaVersions(this.getPartitionId(), namespace);
            versions.put(namespace, v);
        }
        return new ReplicaFragmentMigrationState(versions, operations);
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.fragmentedMigrationEnabled);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fragmentedMigrationEnabled = in.readBoolean();
    }

    private static class ServiceNamespacesContext {
        final Collection<ServiceNamespace> allNamespaces = new HashSet<ServiceNamespace>();
        final Map<ServiceNamespace, Collection<String>> namespaceToServices = new HashMap<ServiceNamespace, Collection<String>>();
        final Iterator<ServiceNamespace> namespaceIterator;

        ServiceNamespacesContext(NodeEngineImpl nodeEngine, PartitionReplicationEvent event) {
            Collection<ServiceInfo> services = nodeEngine.getServiceInfos(FragmentedMigrationAwareService.class);
            for (ServiceInfo serviceInfo : services) {
                FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)serviceInfo.getService();
                Collection<ServiceNamespace> namespaces = service.getAllServiceNamespaces(event);
                if (namespaces == null) continue;
                String serviceName = serviceInfo.getName();
                this.allNamespaces.addAll(namespaces);
                this.addNamespaceToServiceMappings(namespaces, serviceName);
            }
            this.allNamespaces.add(NonFragmentedServiceNamespace.INSTANCE);
            this.namespaceIterator = this.allNamespaces.iterator();
        }

        private void addNamespaceToServiceMappings(Collection<ServiceNamespace> namespaces, String serviceName) {
            for (ServiceNamespace ns : namespaces) {
                Collection<String> serviceNames = this.namespaceToServices.get(ns);
                if (serviceNames == null) {
                    this.namespaceToServices.put(ns, Collections.singleton(serviceName));
                    continue;
                }
                if (serviceNames.size() == 1) {
                    serviceNames = new HashSet<String>(serviceNames);
                    serviceNames.add(serviceName);
                    this.namespaceToServices.put(ns, serviceNames);
                    continue;
                }
                serviceNames.add(serviceName);
            }
        }

        boolean hasNext() {
            return this.namespaceIterator.hasNext();
        }

        ServiceNamespace next() {
            return this.namespaceIterator.next();
        }

        Collection<String> getServiceNames(ServiceNamespace ns) {
            return this.namespaceToServices.get(ns);
        }
    }

    private final class SendNewMigrationFragmentRunnable
    implements PartitionSpecificRunnable,
    UrgentSystemOperation {
        private SendNewMigrationFragmentRunnable() {
        }

        @Override
        public int getPartitionId() {
            return MigrationRequestOperation.this.getPartitionId();
        }

        @Override
        public void run() {
            MigrationRequestOperation.this.trySendNewFragment();
        }
    }

    private final class MigrationCallback
    extends SimpleExecutionCallback<Object> {
        private MigrationCallback() {
        }

        @Override
        public void notify(Object result) {
            if (Boolean.TRUE.equals(result)) {
                if (MigrationRequestOperation.this.fragmentedMigrationEnabled) {
                    InternalOperationService operationService = (InternalOperationService)MigrationRequestOperation.this.getNodeEngine().getOperationService();
                    operationService.execute(new SendNewMigrationFragmentRunnable());
                } else {
                    MigrationRequestOperation.this.completeMigration(true);
                }
            } else {
                MigrationRequestOperation.this.completeMigration(false);
            }
        }
    }
}

