/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaInterestsInfoCmd
extends AbstractInfoCmd {
    int[] categoryCodes;
    String[] interests;

    protected MetaInterestsInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected MetaInterestsInfoCmd(long uin, int id, int[] categoryCodes, String[] interests) {
        super(uin, AbstractIcqCmd.CMD_META_INTERESTS_INFO_CMD, id);
        DefensiveTools.checkNull((Object)categoryCodes, (String)"categoryCodes");
        DefensiveTools.checkNull((Object)interests, (String)"interests");
        if (categoryCodes.length != interests.length) {
            throw new IllegalArgumentException("Count of category codes must equal count of interests");
        }
    }

    protected void readInfo(InputStream is) throws IOException {
        int count = is.read();
        this.interests = new String[count];
        this.categoryCodes = new int[count];
        for (int i = 0; i < count; ++i) {
            this.categoryCodes[i] = LEBinaryTools.readUShort(is);
            this.interests[i] = LEBinaryTools.readUShortLengthString(is, "US-ASCII");
        }
    }

    protected void writeInfo(OutputStream out) throws IOException {
        out.write(this.interests.length);
        for (int i = 0; i < this.interests.length; ++i) {
            LEBinaryTools.writeUShort(out, this.categoryCodes[i]);
            LEBinaryTools.writeUShortLengthString(out, this.interests[i]);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MetaInterestInfoCmd: interests={");
        for (int i = 0; i < this.interests.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.categoryCodes[i]).append(" :");
            result.append(this.interests[i]);
        }
        result.append(" } in ").append(super.toString());
        return result.toString();
    }
}

