/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.LogRecord;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.sip.header.TimeStampHeader;

public class ServerLog {
    private boolean logContent;
    protected LogWriter logWriter;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_EXCEPTION = 17;
    public static final int TRACE_DEBUG = 32;
    private String logFileName;
    protected PrintWriter printWriter;
    protected PrintStream traceWriter = System.out;
    protected String auxInfo;
    protected String description;
    protected String stackIpAddress;
    private SIPTransactionStack sipStack;
    private Properties configurationProperties;
    private PrintStream trace = System.out;
    protected int traceLevel = 16;

    public ServerLog(SIPTransactionStack sIPTransactionStack, Properties properties) {
        this.logWriter = sIPTransactionStack.logWriter;
        this.sipStack = sIPTransactionStack;
        this.setProperties(properties);
    }

    private void setProperties(Properties properties) {
        this.configurationProperties = properties;
        this.description = properties.getProperty("javax.sip.STACK_NAME");
        this.stackIpAddress = properties.getProperty("javax.sip.IP_ADDRESS");
        this.logFileName = properties.getProperty("gov.nist.javax.sip.SERVER_LOG");
        String string = properties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        if (string != null) {
            try {
                int n = string.equals("DEBUG") ? 32 : (string.equals("TRACE") ? 16 : (string.equals("ERROR") ? 17 : (string.equals("NONE") ? 0 : Integer.parseInt(string))));
                this.setTraceLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ServerLog: WARNING Bad integer " + string);
                System.out.println("logging dislabled ");
                this.setTraceLevel(0);
            }
        }
        this.checkLogFile();
    }

    public void setStackIpAddress(String string) {
        this.stackIpAddress = string;
    }

    public void closeLogFile() {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
    }

    public void checkLogFile() {
        if (this.logFileName == null || this.traceLevel < 16) {
            return;
        }
        try {
            File file = new File(this.logFileName);
            if (!file.exists()) {
                file.createNewFile();
                this.printWriter = null;
            }
            if (this.printWriter == null) {
                String string = this.configurationProperties.getProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT");
                this.logContent = string != null && string.equals("true");
                FileWriter fileWriter = new FileWriter(this.logFileName, true);
                this.printWriter = new PrintWriter((Writer)fileWriter, true);
                this.printWriter.println("<!-- Use the  Trace Viewer in src/tools/tracesviewer to view this  trace  \nHere are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.STACK_NAME= " + this.configurationProperties.getProperty("javax.sip.STACK_NAME") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "-->");
                if (this.auxInfo != null) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.logWriter.logDebug("Here are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS") + "\n" + "gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS") + "\n" + "gov.nist.javax.sip.REENTRANT_LISTENER= " + this.configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER") + "gov.nist.javax.sip.THREAD_POOL_SIZE= " + this.configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE") + "\n");
                        this.logWriter.logDebug(" ]]> ");
                        this.logWriter.logDebug("</debug>");
                        this.logWriter.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\"\n auxInfo=\"" + this.auxInfo + "\"/>\n ");
                        this.logWriter.logDebug("<debug>");
                        this.logWriter.logDebug("<![CDATA[ ");
                    }
                } else if (this.sipStack.isLoggingEnabled()) {
                    this.logWriter.logDebug("Here are the stack configuration properties \n" + this.configurationProperties + "\n");
                    this.logWriter.logDebug(" ]]>");
                    this.logWriter.logDebug("</debug>");
                    this.logWriter.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\" />\n");
                    this.logWriter.logDebug("<debug>");
                    this.logWriter.logDebug("<![CDATA[ ");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needsLogging() {
        return this.logFileName != null;
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    private void logMessage(String string) {
        this.checkLogFile();
        String string2 = string;
        if (this.printWriter == null) {
            System.out.println(string2);
        } else {
            this.printWriter.println(string2);
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.logWriter.logDebug(" ]]>");
            this.logWriter.logDebug("</debug>");
            this.logWriter.logDebug(string2);
            this.logWriter.logDebug("<debug>");
            this.logWriter.logDebug("<![CDATA[ ");
        }
    }

    private void logMessage(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, long l, long l2) {
        LogRecord logRecord = this.sipStack.logRecordFactory.createLogRecord(string, string2, string3, l, bl, string5, string7, string4, l2);
        if (logRecord != null) {
            this.logMessage(((Object)logRecord).toString());
        }
    }

    public void logMessage(SIPMessage sIPMessage, String string, String string2, boolean bl, long l) {
        this.checkLogFile();
        CallID callID = (CallID)sIPMessage.getCallId();
        String string3 = null;
        if (callID != null) {
            string3 = callID.getCallId();
        }
        String string4 = sIPMessage.getFirstLine().trim();
        String string5 = this.logContent ? sIPMessage.encode() : sIPMessage.encodeMessage();
        String string6 = sIPMessage.getTransactionId();
        TimeStampHeader timeStampHeader = (TimeStampHeader)sIPMessage.getHeader("Timestamp");
        long l2 = timeStampHeader == null ? 0L : timeStampHeader.getTime();
        this.logMessage(string5, string, string2, bl, string3, string4, null, string6, l, l2);
    }

    public void logMessage(SIPMessage sIPMessage, String string, String string2, String string3, boolean bl, long l) {
        this.checkLogFile();
        CallID callID = (CallID)sIPMessage.getCallId();
        String string4 = null;
        if (callID != null) {
            string4 = callID.getCallId();
        }
        String string5 = sIPMessage.getFirstLine().trim();
        String string6 = this.logContent ? sIPMessage.encode() : sIPMessage.encodeMessage();
        String string7 = sIPMessage.getTransactionId();
        TimeStampHeader timeStampHeader = (TimeStampHeader)sIPMessage.getHeader("Timestamp");
        long l2 = timeStampHeader == null ? 0L : timeStampHeader.getTime();
        this.logMessage(string6, string, string2, bl, string4, string5, string3, string7, l, l2);
    }

    public void logMessage(SIPMessage sIPMessage, String string, String string2, String string3, boolean bl) {
        this.logMessage(sIPMessage, string, string2, string3, bl, System.currentTimeMillis());
    }

    public void logException(Exception exception) {
        if (this.traceLevel >= 17) {
            this.checkLogFile();
            exception.printStackTrace();
            if (this.printWriter != null) {
                exception.printStackTrace(this.printWriter);
            }
        }
    }

    public void println(String string) {
        if (this.traceLevel == 32) {
            System.out.println(string);
        }
    }

    public void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setAuxInfo(String string) {
        this.auxInfo = string;
    }
}

