/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.AttributeValue;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.Nmtoken;
import weblogic.xml.babel.scanner.PEReference;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class AttributeListDeclaration {
    private ScannerState state;
    private Name name;
    private Nmtoken nmtoken;
    private AttributeValue attValue;
    private PEReference perReference;

    AttributeListDeclaration(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
        this.nmtoken = new Nmtoken(scannerState);
        this.attValue = new AttributeValue(scannerState);
    }

    public void read() throws IOException, ScannerException {
        this.state.pushToken(this.state.tokenFactory.createToken(40));
        this.state.skipDTDSpace();
        this.name.read();
        this.state.skipDTDSpace();
        while (Name.isNameBegin(this.state.currentChar)) {
            this.readAttributeDefinition();
            this.state.skipDTDSpace();
        }
        this.state.skipDTDSpace();
        this.state.expect('>');
        this.state.pushToken(this.state.tokenFactory.createToken(39));
    }

    private void readAttributeDefinition() throws IOException, ScannerException {
        this.state.skipDTDSpace();
        this.name.read();
        this.readAttributeType();
        this.readDefaultDeclaration();
    }

    private void readAttributeType() throws IOException, ScannerException {
        this.state.skipDTDSpace();
        if (this.state.currentChar == '(') {
            this.readEnumeratedType();
            return;
        }
        String string = this.name.stringRead();
        if (string.equals("CDATA")) {
            this.state.pushToken(this.state.tokenFactory.createToken(11));
        } else if (string.equals("ID")) {
            this.state.pushToken(this.state.tokenFactory.createToken(41));
        } else if (string.equals("IDREF")) {
            this.state.pushToken(this.state.tokenFactory.createToken(42));
        } else if (string.equals("IDREFS")) {
            this.state.pushToken(this.state.tokenFactory.createToken(43));
        } else if (string.equals("ENTITY")) {
            this.state.pushToken(this.state.tokenFactory.createToken(44));
        } else if (string.equals("ENTITIES")) {
            this.state.pushToken(this.state.tokenFactory.createToken(45));
        } else if (string.equals("NMTOKEN")) {
            this.state.pushToken(this.state.tokenFactory.createToken(46));
        } else if (string.equals("NMTOKENS")) {
            this.state.pushToken(this.state.tokenFactory.createToken(47));
        } else if (string.equals("NOTATION")) {
            this.readNotation();
        } else {
            throw new ScannerException("An attribute definition must contain an attribute type which can be an enumerated type or one of the following: CDATA, ID, IDREF, IDREFS, ENTITY, ENTITIES, NMTOKEN, NMTOKENS. [" + string + "] was read", this.state);
        }
    }

    private void readNotation() throws IOException, ScannerException {
        this.state.pushToken(this.state.tokenFactory.createToken(48));
        this.state.skipDTDSpace();
        this.state.expect('(');
        this.state.pushToken(this.state.tokenFactory.createToken(30));
        this.state.skipDTDSpace();
        this.name.read();
        this.state.skipDTDSpace();
        while (this.state.currentChar == '|') {
            this.state.read();
            this.state.pushToken(this.state.tokenFactory.createToken(35));
            this.state.skipDTDSpace();
            this.name.read();
            this.state.skipDTDSpace();
        }
        this.state.expect(')');
        this.state.pushToken(this.state.tokenFactory.createToken(31));
    }

    private void readEnumeratedType() throws IOException, ScannerException {
        this.state.expect('(');
        this.state.pushToken(this.state.tokenFactory.createToken(30));
        this.state.skipDTDSpace();
        this.nmtoken.read();
        this.state.skipDTDSpace();
        while (this.state.currentChar == '|') {
            this.state.read();
            this.state.pushToken(this.state.tokenFactory.createToken(35));
            this.state.skipDTDSpace();
            this.nmtoken.read();
            this.state.skipDTDSpace();
        }
        this.state.expect(')');
        this.state.pushToken(this.state.tokenFactory.createToken(31));
    }

    private void readDefaultDeclaration() throws IOException, ScannerException {
        this.state.skipDTDSpace();
        if (this.state.currentChar == '#') {
            this.state.read();
            String string = this.name.stringRead();
            if (string.equals("IMPLIED")) {
                this.state.pushToken(this.state.tokenFactory.createToken(50));
                return;
            }
            if (string.equals("REQUIRED")) {
                this.state.pushToken(this.state.tokenFactory.createToken(49));
                return;
            }
            if (string.equals("FIXED")) {
                this.state.pushToken(this.state.tokenFactory.createToken(51));
                this.state.skipDTDSpace();
                this.attValue.read();
            }
        } else {
            this.attValue.read();
        }
    }
}

