/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingCHG;
import net.sf.jml.protocol.outgoing.OutgoingUUX;
import net.sf.jml.util.NumberUtils;

public class IncomingSYN
extends MsnIncomingMessage {
    public IncomingSYN(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public String getVersion() {
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return this.getParam(0);
        }
        return this.getParam(0) + " " + this.getParam(1);
    }

    public int getContactCount() {
        String string = this.protocol.before(MsnProtocol.MSNP10) ? this.getParam(1) : this.getParam(2);
        if (string == null) {
            return -1;
        }
        return NumberUtils.stringToInt(string);
    }

    public int getGroupCount() {
        String string = this.protocol.before(MsnProtocol.MSNP10) ? this.getParam(2) : this.getParam(3);
        if (string == null) {
            return -1;
        }
        return NumberUtils.stringToInt(string);
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnMessenger msnMessenger = msnSession.getMessenger();
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)msnMessenger.getContactList();
        String string = this.getVersion();
        if (string.equals(msnContactListImpl.getVersion())) {
            ((AbstractMessenger)msnMessenger).fireContactListSyncCompleted();
        } else {
            int n = this.getGroupCount();
            if (!this.protocol.before(MsnProtocol.MSNP10)) {
                ++n;
            }
            msnContactListImpl.setVersion(string);
            msnContactListImpl.setGroupCount(n);
            msnContactListImpl.setContactCount(this.getContactCount());
        }
        if (this.protocol.before(MsnProtocol.MSNP13)) {
            MsnOutgoingMessage msnOutgoingMessage;
            MsnProtocol msnProtocol = msnMessenger.getActualMsnProtocol();
            msnMessenger.getOwner().setDisplayName(msnMessenger.getOwner().getDisplayName());
            if (msnProtocol.after(MsnProtocol.MSNP9)) {
                msnOutgoingMessage = new OutgoingUUX(msnProtocol);
                ((OutgoingUUX)msnOutgoingMessage).setPersonalMessage(msnMessenger.getOwner().getPersonalMessage());
                ((OutgoingUUX)msnOutgoingMessage).setMachineGuid("{F26D1F07-95E2-403C-BC18-D4BFED493428}");
                msnMessenger.send(msnOutgoingMessage);
            }
            msnOutgoingMessage = new OutgoingCHG(msnProtocol);
            ((OutgoingCHG)msnOutgoingMessage).setStatus(msnMessenger.getOwner().getInitStatus());
            ((OutgoingCHG)msnOutgoingMessage).setClientId(msnMessenger.getOwner().getClientId());
            ((OutgoingCHG)msnOutgoingMessage).setDisplayPicture(msnMessenger.getOwner().getDisplayPicture());
            ((OutgoingCHG)msnOutgoingMessage).setFirstSend(true);
            msnMessenger.send(msnOutgoingMessage);
        }
    }
}

