/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class AuthReplyCmd
extends SsiCommand {
    private static int FLAG_AUTH_ACCEPTED = 1;
    private static int FLAG_AUTH_DECLINED = 0;
    private String uin = null;
    private String reason = null;
    private boolean accepted = false;

    public AuthReplyCmd(String uin, String reason, boolean accepted) {
        super(26);
        this.uin = uin;
        this.reason = reason;
        this.accepted = accepted;
    }

    public AuthReplyCmd(SnacPacket packet) {
        super(27);
        ByteBlock messageData = packet.getData();
        int offset = 0;
        short uinLen = BinaryTools.getUByte((ByteBlock)messageData, (int)offset++);
        this.uin = OscarTools.getString(messageData.subBlock(offset, (int)uinLen), "US-ASCII");
        offset += uinLen;
        this.accepted = BinaryTools.getUByte((ByteBlock)messageData, (int)offset++) == FLAG_AUTH_ACCEPTED;
        int reasonLen = BinaryTools.getUShort((ByteBlock)messageData, (int)offset);
        this.reason = OscarTools.getString(messageData.subBlock(offset += 2, reasonLen), "US-ASCII");
    }

    public void writeData(OutputStream out) throws IOException {
        byte[] uinBytes = BinaryTools.getAsciiBytes((String)this.uin);
        BinaryTools.writeUByte((OutputStream)out, (int)uinBytes.length);
        out.write(uinBytes);
        if (this.accepted) {
            BinaryTools.writeUByte((OutputStream)out, (int)FLAG_AUTH_ACCEPTED);
        } else {
            BinaryTools.writeUByte((OutputStream)out, (int)FLAG_AUTH_DECLINED);
        }
        if (this.reason == null) {
            this.reason = "";
        }
        byte[] reasonBytes = BinaryTools.getAsciiBytes((String)this.reason);
        BinaryTools.writeUShort((OutputStream)out, (int)reasonBytes.length);
        out.write(reasonBytes);
    }

    public String getSender() {
        return this.uin;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isAccepted() {
        return this.accepted;
    }
}

