/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.DialogFilter;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import javax.sip.TransactionState;

class NistSipMessageFactoryImpl
implements StackMessageFactory {
    private SipStackImpl sipStack;

    public ServerRequestInterface newSIPServerRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        if (messageChannel == null || sIPRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        SipStackImpl sipStackImpl = (SipStackImpl)messageChannel.getSIPStack();
        DialogFilter dialogFilter = new DialogFilter(sipStackImpl);
        if (messageChannel instanceof SIPTransaction) {
            dialogFilter.transactionChannel = (SIPTransaction)messageChannel;
        }
        dialogFilter.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        if (dialogFilter.listeningPoint == null) {
            return null;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Returning request interface for " + sIPRequest.getFirstLine() + " " + dialogFilter + " messageChannel = " + messageChannel);
        }
        return dialogFilter;
    }

    public ServerResponseInterface newSIPServerResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        SIPTransactionStack sIPTransactionStack = messageChannel.getSIPStack();
        SIPTransaction sIPTransaction = sIPTransactionStack.findTransaction(sIPResponse, false);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Found Transaction " + sIPTransaction + " for " + sIPResponse);
        }
        if (sIPTransaction != null) {
            if (sIPTransaction.getState() == null) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Dropping response - null transaction state");
                }
                return null;
            }
            if (TransactionState.COMPLETED == sIPTransaction.getState() && sIPResponse.getStatusCode() / 100 == 1) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Dropping response - late arriving " + sIPResponse.getStatusCode());
                }
                return null;
            }
        }
        DialogFilter dialogFilter = new DialogFilter(this.sipStack);
        dialogFilter.transactionChannel = sIPTransaction;
        dialogFilter.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        return dialogFilter;
    }

    public NistSipMessageFactoryImpl(SipStackImpl sipStackImpl) {
        this.sipStack = sipStackImpl;
    }
}

