/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownLatchPortableHook;
import com.hazelcast.concurrent.countdownlatch.operations.GetCountOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public final class GetCountRequest
extends KeyBasedClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;

    public GetCountRequest() {
    }

    public GetCountRequest(String name) {
        this.name = name;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        return new GetCountOperation(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
    }

    @Override
    public Permission getRequiredPermission() {
        return new CountDownLatchPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "getCount";
    }
}

