/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;

class SegmentReader
extends IndexReader {
    private String segment;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    TermVectorsReader termVectorsReaderOrig = null;
    ThreadLocal termVectorsLocal = new ThreadLocal();
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private boolean undeleteAll = false;
    IndexInput freqStream;
    IndexInput proxStream;
    CompoundFileReader cfsReader = null;
    private Hashtable norms = new Hashtable();
    private static Class IMPL;
    private byte[] ones;

    protected SegmentReader() {
        super(null);
    }

    public static SegmentReader get(SegmentInfo si) throws IOException {
        return SegmentReader.get(si.dir, si, null, false, false);
    }

    public static SegmentReader get(SegmentInfos sis, SegmentInfo si, boolean closeDir) throws IOException {
        return SegmentReader.get(si.dir, si, sis, closeDir, true);
    }

    public static SegmentReader get(Directory dir, SegmentInfo si, SegmentInfos sis, boolean closeDir, boolean ownDir) throws IOException {
        SegmentReader instance;
        try {
            instance = (SegmentReader)IMPL.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        instance.init(dir, sis, closeDir, ownDir);
        instance.initialize(si);
        return instance;
    }

    private void initialize(SegmentInfo si) throws IOException {
        this.segment = si.name;
        Directory cfsDir = this.directory();
        if (this.directory().fileExists(this.segment + ".cfs")) {
            this.cfsReader = new CompoundFileReader(this.directory(), this.segment + ".cfs");
            cfsDir = this.cfsReader;
        }
        this.fieldInfos = new FieldInfos(cfsDir, this.segment + ".fnm");
        this.fieldsReader = new FieldsReader(cfsDir, this.segment, this.fieldInfos);
        this.tis = new TermInfosReader(cfsDir, this.segment, this.fieldInfos);
        if (SegmentReader.hasDeletions(si)) {
            this.deletedDocs = new BitVector(this.directory(), this.segment + ".del");
        }
        this.freqStream = cfsDir.openInput(this.segment + ".frq");
        this.proxStream = cfsDir.openInput(this.segment + ".prx");
        this.openNorms(cfsDir);
        if (this.fieldInfos.hasVectors()) {
            this.termVectorsReaderOrig = new TermVectorsReader(cfsDir, this.segment, this.fieldInfos);
        }
    }

    protected void finalize() {
        this.termVectorsLocal.set(null);
        super.finalize();
    }

    protected void doCommit() throws IOException {
        if (this.deletedDocsDirty) {
            this.deletedDocs.write(this.directory(), this.segment + ".tmp");
            this.directory().renameFile(this.segment + ".tmp", this.segment + ".del");
        }
        if (this.undeleteAll && this.directory().fileExists(this.segment + ".del")) {
            this.directory().deleteFile(this.segment + ".del");
        }
        if (this.normsDirty) {
            Enumeration values = this.norms.elements();
            while (values.hasMoreElements()) {
                Norm norm = (Norm)values.nextElement();
                if (!norm.dirty) continue;
                norm.reWrite();
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.undeleteAll = false;
    }

    protected void doClose() throws IOException {
        this.fieldsReader.close();
        this.tis.close();
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.termVectorsReaderOrig != null) {
            this.termVectorsReaderOrig.close();
        }
        if (this.cfsReader != null) {
            this.cfsReader.close();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.dir.fileExists(si.name + ".del");
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.dir.fileExists(si.name + ".cfs");
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        String[] result = si.dir.list();
        String pattern = si.name + ".s";
        int patternLength = pattern.length();
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].startsWith(pattern) || !Character.isDigit(result[i].charAt(patternLength))) continue;
            return true;
        }
        return false;
    }

    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.undeleteAll = false;
        this.deletedDocs.set(docNum);
    }

    protected void doUndeleteAll() {
        this.deletedDocs = null;
        this.deletedDocsDirty = false;
        this.undeleteAll = true;
    }

    Vector files() throws IOException {
        int i;
        Vector<String> files = new Vector<String>(16);
        for (i = 0; i < IndexFileNames.INDEX_EXTENSIONS.length; ++i) {
            String name = this.segment + "." + IndexFileNames.INDEX_EXTENSIONS[i];
            if (!this.directory().fileExists(name)) continue;
            files.addElement(name);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            String name = this.cfsReader == null ? this.segment + ".f" + i : this.segment + ".s" + i;
            if (!this.directory().fileExists(name)) continue;
            files.addElement(name);
        }
        return files;
    }

    public TermEnum terms() {
        return this.tis.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        return this.tis.terms(t);
    }

    public synchronized Document document(int n) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n);
    }

    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public int docFreq(Term t) throws IOException {
        TermInfo ti = this.tis.get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public int maxDoc() {
        return this.fieldsReader.size();
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public synchronized boolean hasNorms(String field) {
        return this.norms.containsKey(field);
    }

    static byte[] createFakeNorms(int size) {
        byte[] ones = new byte[size];
        Arrays.fill(ones, DefaultSimilarity.encodeNorm(1.0f));
        return ones;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    protected synchronized byte[] getNorms(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] bytes = new byte[this.maxDoc()];
            this.norms(field, bytes, 0);
            Norm.access$302(norm, bytes);
        }
        return norm.bytes;
    }

    public synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = this.getNorms(field);
        if (bytes == null) {
            bytes = this.fakeNorms();
        }
        return bytes;
    }

    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return;
        }
        norm.dirty = true;
        this.normsDirty = true;
        this.norms((String)field)[doc] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            System.arraycopy(this.fakeNorms(), 0, bytes, offset, this.maxDoc());
            return;
        }
        if (norm.bytes != null) {
            System.arraycopy(norm.bytes, 0, bytes, offset, this.maxDoc());
            return;
        }
        IndexInput normStream = (IndexInput)norm.in.clone();
        try {
            normStream.seek(0L);
            normStream.readBytes(bytes, offset, this.maxDoc());
        }
        finally {
            normStream.close();
        }
    }

    private void openNorms(Directory cfsDir) throws IOException {
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            String fileName = this.segment + ".s" + fi.number;
            Directory d = this.directory();
            if (!d.fileExists(fileName)) {
                fileName = this.segment + ".f" + fi.number;
                d = cfsDir;
            }
            this.norms.put(fi.name, new Norm(d.openInput(fileName), fi.number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumerator = this.norms.elements();
            while (enumerator.hasMoreElements()) {
                Norm norm = (Norm)enumerator.nextElement();
                norm.in.close();
            }
        }
    }

    private TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = (TermVectorsReader)this.termVectorsLocal.get();
        if (tvReader == null) {
            tvReader = (TermVectorsReader)this.termVectorsReaderOrig.clone();
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector || this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        if (this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.SegmentReader.class", SegmentReader.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(SegmentReader.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default SegmentReader class: " + e, e);
            }
        }
    }

    private class Norm {
        private IndexInput in;
        private byte[] bytes;
        private boolean dirty;
        private int number;

        public Norm(IndexInput in, int number) {
            this.in = in;
            this.number = number;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reWrite() throws IOException {
            IndexOutput out = SegmentReader.this.directory().createOutput(SegmentReader.this.segment + ".tmp");
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                out.close();
            }
            String fileName = SegmentReader.this.cfsReader == null ? SegmentReader.this.segment + ".f" + this.number : SegmentReader.this.segment + ".s" + this.number;
            SegmentReader.this.directory().renameFile(SegmentReader.this.segment + ".tmp", fileName);
            this.dirty = false;
        }

        static /* synthetic */ byte[] access$302(Norm x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

