/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalExecutorStatsImpl
implements LocalExecutorStats {
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "pending");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> STARTED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "started");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> COMPLETED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "completed");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> CANCELLED_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "cancelled");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> TOTAL_START_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "totalStartLatency");
    private static final AtomicLongFieldUpdater<LocalExecutorStatsImpl> TOTAL_EXECUTION_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalExecutorStatsImpl.class, "totalExecutionTime");
    private long creationTime = Clock.currentTimeMillis();
    private volatile long pending;
    private volatile long started;
    private volatile long completed;
    private volatile long cancelled;
    private volatile long totalStartLatency;
    private volatile long totalExecutionTime;

    public void startPending() {
        PENDING_UPDATER.incrementAndGet(this);
    }

    public void startExecution(long elapsed) {
        TOTAL_START_LATENCY_UPDATER.addAndGet(this, elapsed);
        STARTED_UPDATER.incrementAndGet(this);
        PENDING_UPDATER.decrementAndGet(this);
    }

    public void finishExecution(long elapsed) {
        TOTAL_EXECUTION_TIME_UPDATER.addAndGet(this, elapsed);
        COMPLETED_UPDATER.incrementAndGet(this);
    }

    public void rejectExecution() {
        PENDING_UPDATER.decrementAndGet(this);
    }

    public void cancelExecution() {
        CANCELLED_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getPendingTaskCount() {
        return this.pending;
    }

    @Override
    public long getStartedTaskCount() {
        return this.started;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completed;
    }

    @Override
    public long getCancelledTaskCount() {
        return this.cancelled;
    }

    @Override
    public long getTotalStartLatency() {
        return this.totalStartLatency;
    }

    @Override
    public long getTotalExecutionLatency() {
        return this.totalExecutionTime;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("creationTime", this.creationTime);
        root.add("pending", this.pending);
        root.add("started", this.started);
        root.add("totalStartLatency", this.totalStartLatency);
        root.add("completed", this.completed);
        root.add("totalExecutionTime", this.totalExecutionTime);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        PENDING_UPDATER.set(this, JsonUtil.getLong(json, "pending", -1L));
        STARTED_UPDATER.set(this, JsonUtil.getLong(json, "started", -1L));
        TOTAL_START_LATENCY_UPDATER.set(this, JsonUtil.getLong(json, "totalStartLatency", -1L));
        COMPLETED_UPDATER.set(this, JsonUtil.getLong(json, "completed", -1L));
        TOTAL_EXECUTION_TIME_UPDATER.set(this, JsonUtil.getLong(json, "totalExecutionTime", -1L));
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.pending);
        out.writeLong(this.started);
        out.writeLong(this.totalStartLatency);
        out.writeLong(this.completed);
        out.writeLong(this.totalExecutionTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.creationTime = in.readLong();
        PENDING_UPDATER.set(this, in.readLong());
        STARTED_UPDATER.set(this, in.readLong());
        TOTAL_START_LATENCY_UPDATER.set(this, in.readLong());
        COMPLETED_UPDATER.set(this, in.readLong());
        TOTAL_EXECUTION_TIME_UPDATER.set(this, in.readLong());
    }
}

