/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class KeyRequest
extends AuthCommand {
    private static final int TYPE_SN = 1;
    private final String sn;

    protected KeyRequest(SnacPacket packet) {
        super(6);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ImmutableTlvChain chain = TlvTools.readChain(packet.getData());
        this.sn = chain.getString(1);
    }

    public KeyRequest(String sn) {
        super(6);
        this.sn = sn;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(out);
        }
        new Tlv(75).write(out);
        new Tlv(90).write(out);
    }

    public String toString() {
        return "KeyRequest for screenname " + this.sn;
    }
}

