/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.io.InputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.InvalidFlapHeaderException;
import org.jetbrains.annotations.Nullable;

final class FlapHeader {
    private static final int PARITY_BYTE = 42;
    private final int seqnum;
    private final int channel;
    private final int length;

    @Nullable
    public static FlapHeader readFLAPHeader(InputStream in) throws InvalidFlapHeaderException, IOException {
        DefensiveTools.checkNull((Object)in, (String)"in");
        byte[] header = new byte[6];
        int pos = 0;
        boolean paritied = false;
        while (pos < header.length) {
            int count = in.read(header, pos, header.length - pos);
            if (count == -1) {
                return null;
            }
            if (paritied || (pos += count) < 1) continue;
            paritied = true;
            if (header[0] == 42) continue;
            throw new InvalidFlapHeaderException("first byte of FLAP header must be 0x" + Integer.toHexString(42) + ", was 0x" + Integer.toHexString(header[0]));
        }
        return new FlapHeader(ByteBlock.wrap((byte[])header));
    }

    FlapHeader(ByteBlock bytes) throws IllegalArgumentException {
        DefensiveTools.checkNull((Object)bytes, (String)"bytes");
        if (bytes.getLength() != 6) {
            throw new IllegalArgumentException("FLAP header length (" + bytes.getLength() + ") must be 6");
        }
        if (bytes.get(0) != 42) {
            throw new IllegalArgumentException("FLAP command must begin with 0x2a (started with 0x" + Integer.toHexString(bytes.get(0) & 0xFF) + "): " + BinaryTools.describeData((ByteBlock)bytes.subBlock(0, 6)) + " (data: " + (bytes.getLength() - 6) + " bytes)");
        }
        this.channel = BinaryTools.getUByte((ByteBlock)bytes, (int)1);
        this.seqnum = BinaryTools.getUShort((ByteBlock)bytes, (int)2);
        this.length = BinaryTools.getUShort((ByteBlock)bytes, (int)4);
    }

    public final int getSeqnum() {
        return this.seqnum;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final int getDataLength() {
        return this.length;
    }

    public String toString() {
        return "FlapHeader: seqnum=" + this.seqnum + ", channel=" + this.channel + ", length=" + this.length;
    }
}

