/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.keepalive;

import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.keepalive.KeepAliveEvent;
import net.java.sip.communicator.impl.protocol.jabber.extensions.keepalive.KeepAliveEventProvider;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;

public class KeepAliveManager
implements RegistrationStateChangeListener,
PacketListener {
    private static final Logger logger = Logger.getLogger(KeepAliveManager.class);
    private KeepAliveSendTask keepAliveSendTask = null;
    private Timer keepAliveTimer;
    private long lastReceiveActivity = 0L;
    private int keepAliveCheckInterval;
    private String waitingForPacketWithID = null;
    private ProtocolProviderServiceJabberImpl parentProvider = null;

    public KeepAliveManager(ProtocolProviderServiceJabberImpl parentProvider) {
        this.parentProvider = parentProvider;
        this.parentProvider.addRegistrationStateChangeListener(this);
        ProviderManager.getInstance().addIQProvider("ping", "urn:xmpp:ping", (Object)new KeepAliveEventProvider());
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
        }
        if (evt.getNewState() == RegistrationState.REGISTERED) {
            this.parentProvider.getConnection().removePacketListener((PacketListener)this);
            this.parentProvider.getConnection().addPacketListener((PacketListener)this, null);
            if (this.keepAliveSendTask != null) {
                logger.error((Object)("Those task is not supposed to be available for " + this.parentProvider.getAccountID().getDisplayName()));
                this.keepAliveSendTask.cancel();
                this.keepAliveSendTask = null;
            }
            if (this.keepAliveTimer != null) {
                logger.error((Object)("Those timer is not supposed to be available for " + this.parentProvider.getAccountID().getDisplayName()));
                this.keepAliveTimer.cancel();
                this.keepAliveTimer = null;
            }
            this.keepAliveSendTask = new KeepAliveSendTask();
            this.waitingForPacketWithID = null;
            this.keepAliveCheckInterval = SmackConfiguration.getKeepAliveInterval();
            if (this.keepAliveCheckInterval == 0) {
                this.keepAliveCheckInterval = 30000;
            }
            this.keepAliveTimer = new Timer("Jabber keepalive timer for <" + this.parentProvider.getAccountID() + ">", true);
            this.keepAliveTimer.scheduleAtFixedRate((TimerTask)this.keepAliveSendTask, this.keepAliveCheckInterval, (long)this.keepAliveCheckInterval);
        } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED) {
            this.waitingForPacketWithID = null;
            if (this.parentProvider.getConnection() != null) {
                this.parentProvider.getConnection().removePacketListener((PacketListener)this);
            }
            if (this.keepAliveSendTask != null) {
                this.keepAliveSendTask.cancel();
                this.keepAliveSendTask = null;
            }
            if (this.keepAliveTimer != null) {
                this.keepAliveTimer.cancel();
                this.keepAliveTimer = null;
            }
        }
    }

    public void processPacket(Packet packet) {
        KeepAliveEvent evt;
        this.lastReceiveActivity = System.currentTimeMillis();
        if (this.waitingForPacketWithID != null && this.waitingForPacketWithID.equals(packet.getPacketID())) {
            this.waitingForPacketWithID = null;
        }
        if (packet instanceof KeepAliveEvent && (evt = (KeepAliveEvent)packet).getFrom() != null && evt.getFrom().equals(this.parentProvider.getAccountID().getService())) {
            this.parentProvider.getConnection().sendPacket((Packet)IQ.createResultIQ((IQ)evt));
        }
    }

    private class KeepAliveSendTask
    extends TimerTask {
        private final long MIN_WAKE_UP_INTERVAL = 5000L;
        private long lastWakeUp;

        private KeepAliveSendTask() {
        }

        @Override
        public void run() {
            long sleepDuration = System.currentTimeMillis() - this.lastWakeUp;
            this.lastWakeUp = System.currentTimeMillis();
            if (sleepDuration < 5000L) {
                logger.error((Object)(this + " woken up too early !"));
                return;
            }
            if (!KeepAliveManager.this.parentProvider.isRegistered()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("provider not registered. won't send keep alive for " + KeepAliveManager.this.parentProvider.getAccountID().getDisplayName()));
                }
                KeepAliveManager.this.parentProvider.unregisterInternal(false);
                KeepAliveManager.this.parentProvider.fireRegistrationStateChanged(KeepAliveManager.this.parentProvider.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
                return;
            }
            if (System.currentTimeMillis() - KeepAliveManager.this.lastReceiveActivity > (long)KeepAliveManager.this.keepAliveCheckInterval) {
                if (KeepAliveManager.this.waitingForPacketWithID != null) {
                    logger.error((Object)("un-registering not received ping packet for: " + KeepAliveManager.this.parentProvider.getAccountID().getDisplayName()));
                    KeepAliveManager.this.parentProvider.unregisterInternal(false);
                    KeepAliveManager.this.parentProvider.fireRegistrationStateChanged(KeepAliveManager.this.parentProvider.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 8, null);
                    return;
                }
                try {
                    KeepAliveEvent ping = new KeepAliveEvent(KeepAliveManager.this.parentProvider.getOurJID(), StringUtils.parseServer((String)KeepAliveManager.this.parentProvider.getAccountID().getAccountAddress()));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("send keepalive for acc: " + KeepAliveManager.this.parentProvider.getAccountID().getDisplayName()));
                    }
                    KeepAliveManager.this.waitingForPacketWithID = ping.getPacketID();
                    KeepAliveManager.this.parentProvider.getConnection().sendPacket((Packet)ping);
                }
                catch (Throwable t) {
                    logger.error((Object)"Error sending ping request!", t);
                    KeepAliveManager.this.waitingForPacketWithID = null;
                }
            }
        }
    }
}

