/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.video;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Graphics;
import org.jitsi.impl.neomedia.jmfext.media.renderer.video.JAWTRenderer;
import org.jitsi.util.OSUtils;

public class JAWTRendererVideoComponent
extends Canvas {
    private static final long serialVersionUID = 0L;
    protected final JAWTRenderer renderer;
    private boolean wantsPaint = true;

    public JAWTRendererVideoComponent(JAWTRenderer renderer) {
        this.renderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        this.wantsPaint = true;
        Object object = this.getHandleLock();
        synchronized (object) {
            long handle = this.getHandle();
            if (handle != 0L) {
                try {
                    JAWTRenderer.addNotify(handle, this);
                }
                catch (UnsatisfiedLinkError uler) {
                    // empty catch block
                }
                try {
                    this.paint(null);
                    if (OSUtils.IS_MAC) {
                        int x = this.getX();
                        int y = this.getY();
                        int width = this.getWidth();
                        int height = this.getHeight();
                        this.setBounds(x - 4, y - 4, width + 4, height + 4);
                        this.setBounds(x, y, width, height);
                    }
                }
                finally {
                    this.wantsPaint = true;
                }
            }
        }
    }

    protected long getHandle() {
        return this.renderer.getHandle();
    }

    protected Object getHandleLock() {
        return this.renderer.getHandleLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.wantsPaint && this.getWidth() >= 4 && this.getHeight() >= 4) {
            Object object = this.getHandleLock();
            synchronized (object) {
                long handle = this.getHandle();
                if (handle != 0L) {
                    int zOrder;
                    Container parent = this.getParent();
                    if (parent == null) {
                        zOrder = -1;
                    } else {
                        zOrder = parent.getComponentZOrder(this);
                        if (OSUtils.IS_MAC && zOrder != -1) {
                            zOrder = parent.getComponentCount() - 1 - zOrder;
                        }
                    }
                    this.wantsPaint = JAWTRenderer.paint(handle, this, g, zOrder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getHandleLock();
        synchronized (object) {
            long handle = this.getHandle();
            if (handle != 0L) {
                try {
                    JAWTRenderer.removeNotify(handle, this);
                }
                catch (UnsatisfiedLinkError uler) {
                    // empty catch block
                }
            }
        }
        this.wantsPaint = true;
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g) {
        Object object = this.getHandleLock();
        synchronized (object) {
            if (!this.wantsPaint || this.getHandle() == 0L) {
                super.update(g);
                return;
            }
        }
        this.paint(g);
    }
}

