/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.SourceCloneable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.VideoMediaStreamImpl;
import org.jitsi.impl.neomedia.codec.video.HFlip;
import org.jitsi.impl.neomedia.codec.video.SwScale;
import org.jitsi.impl.neomedia.codec.video.h264.DePacketizer;
import org.jitsi.impl.neomedia.codec.video.h264.JNIDecoder;
import org.jitsi.impl.neomedia.codec.video.h264.JNIEncoder;
import org.jitsi.impl.neomedia.control.ImgStreamingControl;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.transform.ControlTransformInputStream;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.control.KeyFrameControlAdapter;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageCreateListener;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.VideoMediaFormat;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.SizeChangeVideoEvent;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;
import org.jitsi.util.event.VideoNotifierSupport;
import org.jitsi.util.swing.VideoLayout;

public class VideoMediaDeviceSession
extends MediaDeviceSession
implements RTCPFeedbackMessageCreateListener {
    private static final String DESKTOP_STREAMING_ICON = "impl.media.DESKTOP_STREAMING_ICON";
    private static final Logger logger = Logger.getLogger(VideoMediaDeviceSession.class);
    private RTCPFeedbackMessageListener encoder = null;
    private KeyFrameControl keyFrameControl;
    private KeyFrameControl.KeyFrameRequester keyFrameRequester;
    private Player localPlayer;
    private final Object localPlayerSyncRoot = new Object();
    private long localSSRC = -1L;
    private Dimension outputSize;
    private SwScale playerScaler;
    private long remoteSSRC = -1L;
    private List<RTCPFeedbackMessageCreateListener> rtcpFeedbackMessageCreateListeners = new LinkedList<RTCPFeedbackMessageCreateListener>();
    private AbstractRTPConnector rtpConnector;
    private boolean useRTCPFeedbackPLI = false;
    private final VideoNotifierSupport videoNotifierSupport = new VideoNotifierSupport(this, false);

    private static Component getVisualComponent(Player player) {
        Component visualComponent;
        block3: {
            visualComponent = null;
            if (player.getState() >= 300) {
                try {
                    visualComponent = player.getVisualComponent();
                }
                catch (NotRealizedError nre) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Called Player#getVisualComponent() on unrealized player " + player, nre);
                }
            }
        }
        return visualComponent;
    }

    public VideoMediaDeviceSession(AbstractMediaDevice device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTCPFeedbackMessageCreateListner(RTCPFeedbackMessageCreateListener listener) {
        List<RTCPFeedbackMessageCreateListener> list = this.rtcpFeedbackMessageCreateListeners;
        synchronized (list) {
            this.rtcpFeedbackMessageCreateListeners.add(listener);
        }
        if (this.encoder != null) {
            listener.onRTCPFeedbackMessageCreate(this.encoder);
        }
    }

    public void addVideoListener(VideoListener listener) {
        this.videoNotifierSupport.addVideoListener(listener);
    }

    @Override
    protected void checkDevice(AbstractMediaDevice device) {
        if (!MediaType.VIDEO.equals((Object)device.getMediaType())) {
            throw new IllegalArgumentException("device");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controllerUpdateForCreateLocalVisualComponent(ControllerEvent ev, boolean hflip) {
        if (ev instanceof ConfigureCompleteEvent) {
            Processor player = (Processor)ev.getSourceController();
            TrackControl[] trackControls = player.getTrackControls();
            if (trackControls != null && trackControls.length != 0) {
                try {
                    TrackControl[] trackControlArray = trackControls;
                    int n = trackControlArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        Codec[] codecArray;
                        TrackControl trackControl = trackControlArray[n2];
                        if (hflip) {
                            Codec[] codecArray2 = new Codec[2];
                            codecArray2[0] = new HFlip();
                            codecArray = codecArray2;
                            codecArray2[1] = new SwScale();
                        } else {
                            Codec[] codecArray3 = new Codec[1];
                            codecArray = codecArray3;
                            codecArray3[0] = new SwScale();
                        }
                        trackControl.setCodecChain(codecArray);
                    }
                }
                catch (UnsupportedPlugInException upiex) {
                    logger.warn("Failed to add HFlip/SwScale Effect", upiex);
                }
            }
            try {
                player.setContentDescriptor(null);
            }
            catch (NotConfiguredError nce) {
                logger.error("Failed to set ContentDescriptor of Processor", nce);
            }
            player.realize();
        } else if (ev instanceof RealizeCompleteEvent) {
            boolean start;
            Player player = (Player)ev.getSourceController();
            Component visualComponent = player.getVisualComponent();
            if (visualComponent == null) {
                start = false;
            } else {
                this.fireVideoEvent(1, visualComponent, 1, false);
                start = true;
            }
            if (start) {
                player.start();
            } else {
                Object object = this.localPlayerSyncRoot;
                synchronized (object) {
                    if (this.localPlayer == player) {
                        this.localPlayer = null;
                    }
                }
                player.stop();
                player.deallocate();
                player.close();
            }
        } else if (ev instanceof SizeChangeEvent) {
            SizeChangeEvent scev = (SizeChangeEvent)ev;
            this.playerSizeChange(scev.getSourceController(), 1, scev.getWidth(), scev.getHeight());
        }
    }

    @Override
    protected DataSource createCaptureDevice() {
        DataSource captureDevice = super.createCaptureDevice();
        if (captureDevice != null) {
            DataSource cloneableDataSource;
            float frameRate;
            MediaLocator locator = captureDevice.getLocator();
            String protocol = locator == null ? null : locator.getProtocol();
            DeviceConfiguration deviceConfig = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration();
            if ("imgstreaming".equals(protocol)) {
                frameRate = 10.0f;
            } else {
                Dimension videoSize = deviceConfig.getVideoSize();
                if (this.outputSize != null && videoSize.height > this.outputSize.height && videoSize.width > this.outputSize.width) {
                    videoSize = this.outputSize;
                }
                Dimension dim = VideoMediaStreamImpl.selectVideoSize(captureDevice, videoSize.width, videoSize.height);
                frameRate = deviceConfig.getFrameRate();
                if (logger.isInfoEnabled() && dim != null) {
                    logger.info("video send resolution: " + dim.width + "x" + dim.height);
                }
            }
            FrameRateControl frameRateControl = (FrameRateControl)captureDevice.getControl(FrameRateControl.class.getName());
            if (frameRateControl != null) {
                float maxSupportedFrameRate = frameRateControl.getMaxSupportedFrameRate();
                if (maxSupportedFrameRate > 0.0f && frameRate > maxSupportedFrameRate) {
                    frameRate = maxSupportedFrameRate;
                }
                if (frameRate > 0.0f) {
                    frameRateControl.setFrameRate(frameRate);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("video send FPS: " + (frameRate == -1.0f ? "default(no restriction)" : Float.valueOf(frameRate)));
                }
            }
            if (!(captureDevice instanceof SourceCloneable) && (cloneableDataSource = Manager.createCloneableDataSource(captureDevice)) != null) {
                captureDevice = cloneableDataSource;
            }
        }
        return captureDevice;
    }

    private Player createLocalPlayer() {
        return this.createLocalPlayer(this.getCaptureDevice());
    }

    protected Player createLocalPlayer(DataSource captureDevice) {
        DataSource dataSource = captureDevice instanceof SourceCloneable ? ((SourceCloneable)((Object)captureDevice)).createClone() : null;
        Processor localPlayer = null;
        if (dataSource != null) {
            Exception exception = null;
            try {
                localPlayer = Manager.createProcessor(dataSource);
            }
            catch (Exception ex) {
                exception = ex;
            }
            if (exception == null) {
                if (localPlayer != null) {
                    final boolean hflip = captureDevice.getControl(ImgStreamingControl.class.getName()) == null;
                    localPlayer.addControllerListener(new ControllerListener(){

                        @Override
                        public void controllerUpdate(ControllerEvent ev) {
                            VideoMediaDeviceSession.this.controllerUpdateForCreateLocalVisualComponent(ev, hflip);
                        }
                    });
                    localPlayer.configure();
                }
            } else {
                logger.error("Failed to connect to " + MediaStreamImpl.toString(dataSource), exception);
            }
        }
        return localPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component createLocalVisualComponent() {
        Component localVisualComponent;
        if (OSUtils.IS_ANDROID) {
            return null;
        }
        DataSource captureDevice = this.getCaptureDevice();
        if (captureDevice != null && captureDevice.getControl(ImgStreamingControl.class.getName()) != null) {
            return this.createLocalVisualComponentForDesktopStreaming();
        }
        Object object = this.localPlayerSyncRoot;
        synchronized (object) {
            if (this.localPlayer == null) {
                this.localPlayer = this.createLocalPlayer();
            }
            localVisualComponent = this.localPlayer == null ? null : VideoMediaDeviceSession.getVisualComponent(this.localPlayer);
        }
        if (localVisualComponent != null) {
            this.fireVideoEvent(1, localVisualComponent, 1, false);
        }
        return localVisualComponent;
    }

    private Component createLocalVisualComponentForDesktopStreaming() {
        Canvas canvas;
        ImageIcon icon;
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        ImageIcon imageIcon = icon = resources == null ? null : resources.getImage(DESKTOP_STREAMING_ICON);
        if (icon == null) {
            canvas = null;
        } else {
            final Image img = icon.getImage();
            canvas = new Canvas(){
                public static final long serialVersionUID = 0L;

                @Override
                public void paint(Graphics g) {
                    int dstHeight;
                    int dstWidth;
                    int width = this.getWidth();
                    int height = this.getHeight();
                    g.setColor(Color.BLACK);
                    g.fillRect(0, 0, width, height);
                    int imgWidth = img.getWidth(this);
                    int imgHeight = img.getHeight(this);
                    if (imgWidth < 1 || imgHeight < 1) {
                        return;
                    }
                    boolean scale = false;
                    float scaleFactor = 1.0f;
                    if (imgWidth > width) {
                        scale = true;
                        scaleFactor = (float)width / (float)imgWidth;
                    }
                    if (imgHeight > height) {
                        scale = true;
                        scaleFactor = Math.min(scaleFactor, (float)height / (float)imgHeight);
                    }
                    if (scale) {
                        dstWidth = Math.round((float)imgWidth * scaleFactor);
                        dstHeight = Math.round((float)imgHeight * scaleFactor);
                    } else {
                        dstWidth = imgWidth;
                        dstHeight = imgHeight;
                    }
                    int dstX = (width - dstWidth) / 2;
                    int dstY = (height - dstWidth) / 2;
                    g.drawImage(img, dstX, dstY, dstX + dstWidth, dstY + dstHeight, 0, 0, imgWidth, imgHeight, this);
                }
            };
            Dimension iconSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            canvas.setMaximumSize(iconSize);
            canvas.setPreferredSize(iconSize);
            canvas.setName(DESKTOP_STREAMING_ICON);
            this.fireVideoEvent(1, canvas, 1, false);
        }
        return canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeLocalPlayer(Player player) {
        Component visualComponent = null;
        try {
            visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
            player.stop();
            player.deallocate();
            player.close();
        }
        finally {
            Object object = this.localPlayerSyncRoot;
            synchronized (object) {
                if (this.localPlayer == player) {
                    this.localPlayer = null;
                }
            }
            if (visualComponent != null) {
                this.fireVideoEvent(2, visualComponent, 1, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeLocalVisualComponent(Component component) {
        if (component != null) {
            if (DESKTOP_STREAMING_ICON.equals(component.getName())) {
                this.fireVideoEvent(2, component, 1, false);
            } else {
                Component localPlayerVisualComponent;
                Player localPlayer;
                Object object = this.localPlayerSyncRoot;
                synchronized (object) {
                    localPlayer = this.localPlayer;
                }
                if (localPlayer != null && ((localPlayerVisualComponent = VideoMediaDeviceSession.getVisualComponent(localPlayer)) == null || localPlayerVisualComponent == component)) {
                    this.disposeLocalPlayer(localPlayer);
                }
            }
        }
    }

    @Override
    protected void disposePlayer(Player player) {
        Component visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
        super.disposePlayer(player);
        if (visualComponent != null) {
            this.fireVideoEvent(2, visualComponent, 2, false);
        }
    }

    protected boolean fireVideoEvent(int type, Component visualComponent, int origin, boolean wait) {
        if (logger.isTraceEnabled()) {
            logger.trace("Firing VideoEvent with type " + VideoEvent.typeToString(type) + " and origin " + VideoEvent.originToString(origin));
        }
        return this.videoNotifierSupport.fireVideoEvent(type, visualComponent, origin, wait);
    }

    protected void fireVideoEvent(VideoEvent videoEvent, boolean wait) {
        this.videoNotifierSupport.fireVideoEvent(videoEvent, wait);
    }

    private Format getCaptureDeviceFormat() {
        DataSource captureDevice = this.getCaptureDevice();
        if (captureDevice != null) {
            FormatControl formatControl;
            FormatControl[] formatControls = null;
            if (captureDevice instanceof CaptureDevice) {
                formatControls = ((CaptureDevice)((Object)captureDevice)).getFormatControls();
            }
            if ((formatControls == null || formatControls.length == 0) && (formatControl = (FormatControl)captureDevice.getControl(FormatControl.class.getName())) != null) {
                formatControls = new FormatControl[]{formatControl};
            }
            if (formatControls != null) {
                for (FormatControl formatControl2 : formatControls) {
                    Format format = formatControl2.getFormat();
                    if (format == null) continue;
                    return format;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getLocalVisualComponent() {
        Object object = this.localPlayerSyncRoot;
        synchronized (object) {
            return this.localPlayer == null ? null : VideoMediaDeviceSession.getVisualComponent(this.localPlayer);
        }
    }

    public VideoFormat getReceivedVideoFormat() {
        Format format;
        if (this.playerScaler != null && (format = this.playerScaler.getInputFormat()) instanceof VideoFormat) {
            return (VideoFormat)format;
        }
        return null;
    }

    public VideoFormat getSentVideoFormat() {
        DataSource capture = this.getCaptureDevice();
        if (capture instanceof PullBufferDataSource) {
            PullBufferStream[] streams;
            for (PullBufferStream stream : streams = ((PullBufferDataSource)capture).getStreams()) {
                VideoFormat format = (VideoFormat)stream.getFormat();
                if (format == null) continue;
                return format;
            }
        }
        return null;
    }

    public Component getVisualComponent(long ssrc) {
        Player player = this.getPlayer(ssrc);
        return player == null ? null : VideoMediaDeviceSession.getVisualComponent(player);
    }

    public List<Component> getVisualComponents() {
        LinkedList<Component> visualComponents = new LinkedList<Component>();
        if (this.getStartedDirection().allowsReceiving()) {
            for (Player player : this.getPlayers()) {
                Component visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
                if (visualComponent == null) continue;
                visualComponents.add(visualComponent);
            }
        }
        return visualComponents;
    }

    private boolean keyFrameRequesterRequestKeyFrame(KeyFrameControl.KeyFrameRequester keyFrameRequester) {
        boolean requested = false;
        if (this.useRTCPFeedbackPLI) {
            try {
                new RTCPFeedbackMessagePacket(1, -50, this.localSSRC, this.remoteSSRC).writeTo(this.rtpConnector.getControlOutputStream());
                requested = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return requested;
    }

    @Override
    public void onRTCPFeedbackMessageCreate(RTCPFeedbackMessageListener rtcpFeedbackMessageListener) {
        if (this.rtpConnector != null) {
            try {
                ((ControlTransformInputStream)this.rtpConnector.getControlInputStream()).addRTCPFeedbackMessageListener(rtcpFeedbackMessageListener);
            }
            catch (IOException ioe) {
                logger.error("Error cannot get RTCP input stream", ioe);
            }
        }
    }

    @Override
    protected void playerConfigureComplete(Processor player) {
        super.playerConfigureComplete(player);
        TrackControl[] trackControls = player.getTrackControls();
        PlayerScaler playerScaler = null;
        if (trackControls != null && trackControls.length != 0 && !OSUtils.IS_ANDROID) {
            String fmjEncoding = this.getFormat().getJMFEncoding();
            try {
                TrackControl[] trackControlArray = trackControls;
                int n = trackControlArray.length;
                int n2 = 0;
                if (n2 < n) {
                    TrackControl trackControl = trackControlArray[n2];
                    playerScaler = new PlayerScaler(player);
                    if ("h264/rtp".equalsIgnoreCase(fmjEncoding)) {
                        final DePacketizer depacketizer = new DePacketizer();
                        JNIDecoder decoder = new JNIDecoder();
                        if (this.keyFrameControl != null) {
                            depacketizer.setKeyFrameControl(this.keyFrameControl);
                            decoder.setKeyFrameControl(new KeyFrameControlAdapter(){

                                @Override
                                public boolean requestKeyFrame(boolean urgent) {
                                    return depacketizer.requestKeyFrame(urgent);
                                }
                            });
                        }
                        trackControl.setCodecChain(new Codec[]{depacketizer, decoder, playerScaler});
                    } else {
                        trackControl.setCodecChain(new Codec[]{playerScaler});
                    }
                }
            }
            catch (UnsupportedPlugInException upiex) {
                logger.error("Failed to add SwScale or H.264 DePacketizer to codec chain", upiex);
                playerScaler = null;
            }
        }
        this.playerScaler = playerScaler;
    }

    @Override
    protected void playerControllerUpdate(ControllerEvent ev) {
        super.playerControllerUpdate(ev);
        if (ev instanceof SizeChangeEvent && (this.playerScaler == null || this.playerScaler.getOutputSize() == null)) {
            SizeChangeEvent scev = (SizeChangeEvent)ev;
            this.playerSizeChange(scev.getSourceController(), 2, scev.getWidth(), scev.getHeight());
        }
    }

    @Override
    protected void playerRealizeComplete(final Processor player) {
        super.playerRealizeComplete(player);
        Component visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
        if (visualComponent != null) {
            visualComponent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ev) {
                    VideoMediaDeviceSession.this.playerVisualComponentResized(player, ev);
                }
            });
            this.fireVideoEvent(1, visualComponent, 2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playerSizeChange(final Controller sourceController, final int origin, final int width, final int height) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VideoMediaDeviceSession.this.playerSizeChange(sourceController, origin, width, height);
                }
            });
            return;
        }
        Player player = (Player)sourceController;
        Component visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
        if (visualComponent != null) {
            try {
                Dimension prefSize = visualComponent.getPreferredSize();
                if (prefSize == null || prefSize.width < 1 || prefSize.height < 1 || !VideoLayout.areAspectRatiosEqual(prefSize, width, height) || prefSize.width < width || prefSize.height < height) {
                    visualComponent.setPreferredSize(new Dimension(width, height));
                }
            }
            finally {
                this.fireVideoEvent(new SizeChangeVideoEvent(this, visualComponent, origin, width, height), false);
            }
        }
    }

    private void playerVisualComponentResized(Processor player, ComponentEvent ev) {
        float heightRatio;
        float widthRatio;
        if (this.playerScaler == null) {
            return;
        }
        Component visualComponent = ev.getComponent();
        if (visualComponent.isDisplayable()) {
            return;
        }
        Dimension outputSize = visualComponent.getSize();
        float outputWidth = outputSize.width;
        float outputHeight = outputSize.height;
        if (outputWidth < 4.0f || outputHeight < 4.0f) {
            return;
        }
        Format inputFormat = this.playerScaler.getInputFormat();
        if (inputFormat == null) {
            return;
        }
        Dimension inputSize = ((VideoFormat)inputFormat).getSize();
        if (inputSize == null) {
            return;
        }
        int inputWidth = inputSize.width;
        int inputHeight = inputSize.height;
        if (inputWidth < 1 || inputHeight < 1) {
            return;
        }
        outputHeight = outputWidth * (float)inputHeight / (float)inputWidth;
        boolean scale = false;
        if (Math.abs(outputWidth - (float)inputWidth) < 1.0f) {
            scale = true;
            widthRatio = outputWidth / (float)inputWidth;
        } else {
            widthRatio = 1.0f;
        }
        if (Math.abs(outputHeight - (float)inputHeight) < 1.0f) {
            scale = true;
            heightRatio = outputHeight / (float)inputHeight;
        } else {
            heightRatio = 1.0f;
        }
        if (scale) {
            float scaleFactor = Math.min(widthRatio, heightRatio);
            outputWidth = (float)inputWidth * scaleFactor;
            outputHeight = (float)inputHeight * scaleFactor;
        }
        outputSize.width = (int)outputWidth;
        outputSize.height = (int)outputHeight;
        Dimension playerScalerOutputSize = this.playerScaler.getOutputSize();
        if (playerScalerOutputSize == null) {
            this.playerScaler.setOutputSize(outputSize);
        } else {
            int outputWidthDelta = outputSize.width - playerScalerOutputSize.width;
            int outputHeightDelta = outputSize.height - playerScalerOutputSize.height;
            if (outputWidthDelta < -1 || outputWidthDelta > 1 || outputHeightDelta < -1 || outputHeightDelta > 1) {
                this.playerScaler.setOutputSize(outputSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTCPFeedbackMessageCreateListner(RTCPFeedbackMessageCreateListener listener) {
        List<RTCPFeedbackMessageCreateListener> list = this.rtcpFeedbackMessageCreateListeners;
        synchronized (list) {
            this.rtcpFeedbackMessageCreateListeners.remove(listener);
        }
    }

    public void removeVideoListener(VideoListener listener) {
        this.videoNotifierSupport.removeVideoListener(listener);
    }

    public void setConnector(AbstractRTPConnector rtpConnector) {
        this.rtpConnector = rtpConnector;
    }

    @Override
    public void setFormat(MediaFormat format) {
        FrameRateControl frameRateControl;
        if (format instanceof VideoMediaFormat && ((VideoMediaFormat)format).getFrameRate() != -1.0f && (frameRateControl = (FrameRateControl)this.getCaptureDevice().getControl(FrameRateControl.class.getName())) != null) {
            float frameRate = ((VideoMediaFormat)format).getFrameRate();
            float maxSupportedFrameRate = frameRateControl.getMaxSupportedFrameRate();
            if (maxSupportedFrameRate > 0.0f && frameRate > maxSupportedFrameRate) {
                frameRate = maxSupportedFrameRate;
            }
            if (frameRate > 0.0f) {
                frameRateControl.setFrameRate(frameRate);
                if (logger.isInfoEnabled()) {
                    logger.info("video send FPS: " + frameRate);
                }
            }
        }
        super.setFormat(format);
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        if (this.keyFrameControl != keyFrameControl) {
            if (this.keyFrameControl != null && this.keyFrameRequester != null) {
                this.keyFrameControl.removeKeyFrameRequester(this.keyFrameRequester);
            }
            this.keyFrameControl = keyFrameControl;
            if (this.keyFrameControl != null && this.keyFrameRequester != null) {
                this.keyFrameControl.addKeyFrameRequester(-1, this.keyFrameRequester);
            }
        }
    }

    public void setLocalSSRC(long localSSRC) {
        this.localSSRC = localSSRC;
    }

    public void setOutputSize(Dimension size) {
        boolean equal;
        boolean bl = size == null ? this.outputSize == null : (equal = size.equals(this.outputSize));
        if (!equal) {
            this.outputSize = size;
            this.outputSizeChanged = true;
        }
    }

    @Override
    protected void setProcessorFormat(Processor processor, MediaFormatImpl<? extends Format> mediaFormat) {
        Format format = mediaFormat.getFormat();
        if ("h263-1998/rtp".equalsIgnoreCase(format.getEncoding()) && this.outputSize == null) {
            this.outputSize = new Dimension(176, 144);
        }
        if (this.outputSize != null && this.outputSize.width > 0 && this.outputSize.height > 0) {
            Dimension videoFormatSize;
            Dimension deviceSize = ((VideoFormat)this.getCaptureDeviceFormat()).getSize();
            if (deviceSize != null && (deviceSize.width > this.outputSize.width || deviceSize.height > this.outputSize.height)) {
                videoFormatSize = this.outputSize;
            } else {
                videoFormatSize = deviceSize;
                this.outputSize = null;
            }
            VideoFormat videoFormat = (VideoFormat)format;
            format = new VideoFormat(videoFormat.getEncoding(), videoFormatSize, videoFormat.getMaxDataLength(), videoFormat.getDataType(), videoFormat.getFrameRate());
        } else {
            this.outputSize = null;
        }
        super.setProcessorFormat(processor, mediaFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Format setProcessorFormat(TrackControl trackControl, MediaFormatImpl<? extends Format> mediaFormat, Format format) {
        JNIEncoder encoder = null;
        SwScale scaler = null;
        int codecCount = 0;
        if (!OSUtils.IS_ANDROID && "h264/rtp".equalsIgnoreCase(format.getEncoding())) {
            encoder = new JNIEncoder();
            Map<String, String> formatParameters = mediaFormat.getFormatParameters();
            String packetizationMode = formatParameters == null ? null : formatParameters.get("packetization-mode");
            encoder.setPacketizationMode(packetizationMode);
            encoder.setAdditionalCodecSettings(mediaFormat.getAdditionalCodecSettings());
            this.encoder = encoder;
            this.onRTCPFeedbackMessageCreate(encoder);
            formatParameters = this.rtcpFeedbackMessageCreateListeners;
            synchronized (formatParameters) {
                for (RTCPFeedbackMessageCreateListener l : this.rtcpFeedbackMessageCreateListeners) {
                    l.onRTCPFeedbackMessageCreate(encoder);
                }
            }
            if (this.keyFrameControl != null) {
                encoder.setKeyFrameControl(this.keyFrameControl);
            }
            ++codecCount;
        }
        if (this.outputSize != null) {
            scaler = new SwScale(false, true);
            scaler.setOutputSize(this.outputSize);
            ++codecCount;
        }
        Codec[] codecs = new Codec[codecCount];
        codecCount = 0;
        if (scaler != null) {
            codecs[codecCount++] = scaler;
        }
        if (encoder != null) {
            codecs[codecCount++] = encoder;
        }
        if (codecCount != 0) {
            try {
                trackControl.setCodecChain(codecs);
            }
            catch (UnsupportedPlugInException upiex) {
                logger.error("Failed to add SwScale/JNIEncoder to codec chain", upiex);
            }
        }
        return super.setProcessorFormat(trackControl, mediaFormat, format);
    }

    public void setRemoteSSRC(long remoteSSRC) {
        this.remoteSSRC = remoteSSRC;
    }

    public void setRTCPFeedbackPLI(boolean useRTCPFeedbackPLI) {
        if (this.useRTCPFeedbackPLI != useRTCPFeedbackPLI) {
            this.useRTCPFeedbackPLI = useRTCPFeedbackPLI;
            if (this.useRTCPFeedbackPLI) {
                if (this.keyFrameRequester == null) {
                    this.keyFrameRequester = new KeyFrameControl.KeyFrameRequester(){

                        @Override
                        public boolean requestKeyFrame() {
                            return VideoMediaDeviceSession.this.keyFrameRequesterRequestKeyFrame(this);
                        }
                    };
                }
                if (this.keyFrameControl != null) {
                    this.keyFrameControl.addKeyFrameRequester(-1, this.keyFrameRequester);
                }
            } else if (this.keyFrameRequester != null) {
                if (this.keyFrameControl != null) {
                    this.keyFrameControl.removeKeyFrameRequester(this.keyFrameRequester);
                }
                this.keyFrameRequester = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startedDirectionChanged(MediaDirection oldValue, MediaDirection newValue) {
        super.startedDirectionChanged(oldValue, newValue);
        try {
            Player localPlayer;
            Object object = this.localPlayerSyncRoot;
            synchronized (object) {
                localPlayer = this.getLocalPlayer();
            }
            if (newValue.allowsSending()) {
                if (localPlayer == null) {
                    this.createLocalVisualComponent();
                }
            } else if (localPlayer != null) {
                this.disposeLocalPlayer(localPlayer);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to start/stop the preview of the local video", t);
        }
        for (Player player : this.getPlayers()) {
            Component visualComponent;
            int state = player.getState();
            if (state < 300) continue;
            if (newValue.allowsReceiving()) {
                if (state == 600) continue;
                player.start();
                visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
                if (visualComponent == null) continue;
                this.fireVideoEvent(1, visualComponent, 2, false);
                continue;
            }
            if (state <= 180) continue;
            visualComponent = VideoMediaDeviceSession.getVisualComponent(player);
            player.stop();
            if (visualComponent == null) continue;
            this.fireVideoEvent(2, visualComponent, 2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Player getLocalPlayer() {
        Object object = this.localPlayerSyncRoot;
        synchronized (object) {
            return this.localPlayer;
        }
    }

    private class PlayerScaler
    extends SwScale {
        private Dimension lastSize;
        private final Player player;

        public PlayerScaler(Player player) {
            super(true);
            this.player = player;
        }

        @Override
        public int process(Buffer input, Buffer output) {
            Dimension size;
            Format inputFormat;
            int result = super.process(input, output);
            if (result == 0 && (inputFormat = this.getInputFormat()) != null && (size = ((VideoFormat)inputFormat).getSize()) != null && size.height >= 4 && size.width >= 4 && !size.equals(this.lastSize)) {
                this.lastSize = size;
                VideoMediaDeviceSession.this.playerSizeChange(this.player, 2, this.lastSize.width, this.lastSize.height);
            }
            return result;
        }

        @Override
        public Format setInputFormat(Format inputFormat) {
            int outputHeight;
            int outputHeightDelta;
            int outputWidth;
            Dimension outputSize;
            Dimension inputSize;
            if ((inputFormat = super.setInputFormat(inputFormat)) instanceof VideoFormat && (inputSize = ((VideoFormat)inputFormat).getSize()) != null && inputSize.width > 0 && (outputSize = this.getOutputSize()) != null && (outputWidth = outputSize.width) > 0 && ((outputHeightDelta = (outputHeight = (int)((float)(outputWidth * inputSize.height) / (float)inputSize.width)) - outputSize.height) < -1 || outputHeightDelta > 1)) {
                super.setOutputSize(new Dimension(outputWidth, outputHeight));
            }
            return inputFormat;
        }
    }
}

