/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import net.sf.fmj.media.util.MediaThread;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;

public abstract class MaxPacketsPerMillisPolicy {
    public static final int PACKET_QUEUE_CAPACITY;
    private static final String PACKET_QUEUE_CAPACITY_PNAME;
    private boolean closed = false;
    private int maxPackets = -1;
    private long millisStartTime = 0L;
    private final ArrayBlockingQueue<RawPacket> packetQueue = new ArrayBlockingQueue(PACKET_QUEUE_CAPACITY);
    private long packetsSentInMillis = 0L;
    private long perNanos = -1L;
    private Thread sendThread;

    public MaxPacketsPerMillisPolicy(int maxPackets, long perMillis) {
        this.setMaxPacketsPerMillis(maxPackets, perMillis);
        if (this.sendThread == null) {
            this.sendThread = new Thread(){

                @Override
                public void run() {
                    MaxPacketsPerMillisPolicy.this.runInSendThread();
                }
            };
            this.sendThread.setDaemon(true);
            this.sendThread.setName(MaxPacketsPerMillisPolicy.class.getName() + ".sendThread");
            RTPConnectorInputStream.setThreadPriority(this.sendThread, MediaThread.getNetworkPriority());
            this.sendThread.start();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.packetQueue.offer(new RawPacket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInSendThread() {
        try {
            RawPacket packet = null;
            while (!this.closed) {
                if (packet == null) {
                    try {
                        packet = this.packetQueue.take();
                    }
                    catch (InterruptedException iex) {
                        continue;
                    }
                    if (this.closed) {
                        break;
                    }
                }
                long time = System.nanoTime();
                long millisRemainingTime = time - this.millisStartTime;
                if (this.perNanos < 1L || millisRemainingTime >= this.perNanos) {
                    this.millisStartTime = time;
                    this.packetsSentInMillis = 0L;
                } else if (this.maxPackets > 0 && this.packetsSentInMillis >= (long)this.maxPackets) {
                    LockSupport.parkNanos(millisRemainingTime);
                    continue;
                }
                try {
                    this.send(packet);
                }
                finally {
                    packet = null;
                }
                ++this.packetsSentInMillis;
            }
        }
        finally {
            this.packetQueue.clear();
            if (Thread.currentThread().equals(this.sendThread)) {
                this.sendThread = null;
            }
        }
    }

    protected abstract void send(RawPacket var1);

    public void setMaxPacketsPerMillis(int maxPackets, long perMillis) {
        if (maxPackets < 1) {
            this.maxPackets = -1;
            this.perNanos = -1L;
        } else {
            if (perMillis < 1L) {
                throw new IllegalArgumentException("perMillis");
            }
            this.maxPackets = maxPackets;
            this.perNanos = perMillis * 1000000L;
        }
    }

    public void write(RawPacket packet) {
        while (true) {
            try {
                this.packetQueue.put(packet);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static {
        PACKET_QUEUE_CAPACITY_PNAME = MaxPacketsPerMillisPolicy.class.getName() + ".PACKET_QUEUE_CAPACITY";
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        int packetQueueCapacity = 256;
        packetQueueCapacity = cfg == null ? Integer.getInteger(PACKET_QUEUE_CAPACITY_PNAME, packetQueueCapacity).intValue() : cfg.getInt(PACKET_QUEUE_CAPACITY_PNAME, packetQueueCapacity);
        PACKET_QUEUE_CAPACITY = packetQueueCapacity;
    }
}

